package de.lunqual.rzpro.items.rezeptur;

import java.math.BigDecimal;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.currency.CurrencyItem;

public class AusstattungsZeile {

	public static final int	MODE_PLUS = 0;
	public static final int MODE_MAL = 1;

	RzPro				rz;
	int 					mode;
	double			factor;
	String				name;
	BigDecimal		einzelPreis;
	double			gewicht;
	double			zeilenGewicht;
	BigDecimal		zielPreis;
	CurrencyItem	wQuelle;
	CurrencyItem	wZiel;
	BigDecimal		zeilenPreis;

	public AusstattungsZeile(RzPro rz,int mode,double factor,String name,BigDecimal preis,double gewicht,CurrencyItem wQuelle,CurrencyItem wZiel) {
		this.rz = rz;
		this.mode  = mode;
		this.factor =factor;
		this.name = name;
		this.wQuelle = wQuelle;
		this.wZiel = wZiel;
		this.einzelPreis = preis;
		this.gewicht = gewicht;
		this.zielPreis = rz.getDatabase().getCurrency().convert(preis,wQuelle, wZiel);
		rechnen();
	}

	private BigDecimal rechnen() {
		BigDecimal ret=null;
		zeilenGewicht = 0.0;
		try {
			switch (mode) {
				case MODE_PLUS:
					ret = new BigDecimal(factor * zielPreis.doubleValue());
					zeilenGewicht = factor * gewicht;
					break;
				case MODE_MAL:
					ret = new BigDecimal(zielPreis.doubleValue() / factor );
					zeilenGewicht = gewicht / factor;
 					break;
			}
		}catch(final ArithmeticException ae) {
			ret = new BigDecimal(0.0);
			zeilenGewicht = 0.0;
		}
		if(rz.isZero(factor)) {
			zeilenGewicht = gewicht;
		}
		zeilenPreis = ret.setScale(RzPro.CURRENCY_DEFAULT_SCALE,java.math.BigDecimal.ROUND_HALF_UP);
		return zeilenPreis;
	}

	public BigDecimal getZeilenPreis() {
		return zeilenPreis;
	}

	public double getFactor() {
		return factor;
	}

	public String getName() {
		return name;
	}

	public BigDecimal getEinzelPreis() {
		return einzelPreis;
	}

	public BigDecimal getZielPreis() {
		return zielPreis;
	}

	public CurrencyItem getWQuelle() {
		return wQuelle;
	}

	public CurrencyItem getWZiel() {
		return wZiel;
	}

	public int getMode() {
		return mode;
	}
	public double getGewicht() {
		return gewicht;
	}

	public double getZeilenGewicht() {
		return zeilenGewicht;
	}
}
