/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.items.rezeptur;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;

import de.lunqual.rzpro.RzPro;
public class BestandswarnungsListe extends ArrayList {
	RzPro rz;

	Collator coll;
	Comparator compDouble;
	public BestandswarnungsListe(final RzPro rz) {
		super();
		this.rz = rz;
		coll = Collator.getInstance(Locale.getDefault());
        compDouble=new Comparator() {
            public int compare(Object o1,Object o2){
            	final BestandswarnungsItem b1 = (BestandswarnungsItem)o1;
            	final BestandswarnungsItem b2 = (BestandswarnungsItem)o2;
            	int r=0;
                if (b1.getDiff() > b2.getDiff() ) {
                	r=-1;
                }else {
                	if (b1.getDiff() < b2.getDiff() ) {
                		r=1;
                	} else {
                			//alphabetische Ordnung
                			r =  coll.compare(b1.getBezeichnung() ,b2.getBezeichnung());
                	}
                }
                return r;
            }
        };
	}

    /*---------------------------------------------------------
     * die Liste aufsteigend nach diff sortieren
     *---------------------------------------------------------
     */
    public void sortItems(){
        Collections.sort(this,compDouble);
    }

    public void getDatum() {
    	rz.getDatabase().getRezeptur().getBestandswarnungsDatum(this);
    }

    public void setDatum(int id,int datediff) {
    	for(int i=0;i < this.size();i++) {
    		if(getItem(i).getRezeptur() == id) {
    			getItem(i).setLetzteBuchung(datediff);
    			break;
    		}
    	}
    }
    public void addItem(BestandswarnungsItem bi){
        this.add(bi);
    }

    public BestandswarnungsItem getItem(int i){
        return (BestandswarnungsItem)this.get(i);
    }
}
