package de.lunqual.rzpro.items.rezeptur;

import java.util.ArrayList;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.options.OptionFactory;

public class ChangesListe {

	
	RzPro								rz;
	ArrayList<ChangesItem>	liste;
	int									rezeptur_id;
	RezepturItem					rAlt;
	RezepturItem					rNeu;
	NotizItem						nAlt;
	NotizItem						nNeu;
	AusstattungsItem			aAlt;
	AusstattungsItem			aNeu;
	int								typ;
	
	
	public ChangesListe(RzPro rz,int rezeptur_id) {
		this.rz = rz;
		liste = new ArrayList<ChangesItem>();
		this.rezeptur_id=rezeptur_id;
		this.typ = RzPro.TYP_ID_REZEPT;
		getObjectAlt();
	}
	
	public ChangesListe(RzPro rz,int rezeptur_id,int typ) {
		this.rz = rz;
		liste = new ArrayList<ChangesItem>();
		this.rezeptur_id=rezeptur_id;
		this.typ = typ;
		getObjectAlt();
	}
	
	private void getObjectAlt() {
		switch(typ) {
		case RzPro.TYP_ID_REZEPT:
			rAlt = rz.getDatabase().getRezeptur().dbGetRezeptur(rezeptur_id, false);
			break;
		case RzPro.TYP_ID_NOTIZ:
			nAlt = rz.getDatabase().getNotizen().dbGetNotiz(rezeptur_id,false);
			break;
		case RzPro.TYP_ID_AUSSTATTUNG:
			aAlt = rz.getDatabase().getAusstattung().getAusstattung(rezeptur_id);
			break;
		}
	}
	
	
	public ArrayList<ChangesItem> getListe() {
		return liste;
	}

	public int	getRezepturID() {
		return rezeptur_id;
	}
	
	public void add(String meldung,String alt,String neu,boolean relevant) {
		if(rezeptur_id !=0) {
			liste.add(0,new ChangesItem(
					rz,
					0,
					rezeptur_id,
					meldung,
					alt,
					neu,
					null,
					rz.getDatabase().dbGetUser(),
					relevant
			));
		}
	}
	
	
	public void rollback() {
		liste.clear();
	}
	
	
	public void commit() {
		switch (typ) {
			case RzPro.TYP_ID_REZEPT:commitRezeptur();break;
			case RzPro.TYP_ID_NOTIZ:commitNotiz();break;
			case RzPro.TYP_ID_AUSSTATTUNG:commitAusstattung();break;
		}
	}
	
	private void commitAusstattung() {
		aNeu = rz.getDatabase().getAusstattung().getAusstattung(rezeptur_id);
		if(aAlt != null && aNeu != null && liste != null) {
			checkChangesAusstattung();
			if(!liste.isEmpty()) {
				if(	rz.getDatabase().getChanges().commit(this))
				{	
					liste.clear();
				}
			}
		}
	}
	
	
	private void commitNotiz() {
		nNeu = rz.getDatabase().getNotizen().dbGetNotiz(rezeptur_id, false);
		if(nAlt != null && nNeu != null && liste != null) {
			checkChangesNotiz();
			if(!liste.isEmpty()) {
				if(	rz.getDatabase().getChanges().commit(this))
				{	
					liste.clear();
				}
			}
		}
	}
	
	
	private void commitRezeptur() {
		rNeu = rz.getDatabase().getRezeptur().dbGetRezeptur(rezeptur_id, false);
		if(rAlt != null && rNeu != null && liste != null) {
			checkChangesRezeptur();
			if(!liste.isEmpty()) {
				if(	rz.getDatabase().getChanges().commit(this))
				{	
					liste.clear();
				}
			}
		}
	}
	
	
	private void checkChangesAusstattung() {
		if(aAlt.getID() != 0) {
			boolean rv = rz.getDatabase().getChanges().isRelevant(rezeptur_id);
			if(!aAlt.getTitel().equals(aNeu.getTitel().trim())) {
				add(rz.getLocale().getString("changes.titel"), aAlt.getTitel(), aNeu.getTitel().trim(),rv);
			}
			if(!aAlt.getComment().trim().equals(aNeu.getComment().trim())) {
				add(rz.getLocale().getString("changes.ausstattungtext"), aAlt.getComment().trim(), aNeu.getComment().trim(),rv);
			}	
			if(!aAlt.getAdressListe().toString().equals(aNeu.getAdressListe().toString())) {
				add(rz.getLocale().getString("changes.adressliste"), aAlt.getAdressListe().toVerboseString(),aNeu.getAdressListe().toVerboseString(),rv);
			}
			if(!aAlt.getStichwortListe().toString().equals(aNeu.getStichwortListe().toString())) {
				add(rz.getLocale().getString("changes.stichwortliste"), aAlt.getStichwortListe().toVerboseString(),aNeu.getStichwortListe().toVerboseString(),rv);
			}
			if(!aAlt.getArtikelnummer().equals(aNeu.getArtikelnummer())) {
				add(rz.getLocale().getString("changes.artikelnummer"), aAlt.getArtikelnummer(),aNeu.getArtikelnummer(),rv);
			}
			if(!rz.getLocale().formatNumber(aAlt.getGebindeGewicht(),OptionFactory.NF_NORMAL).equals(rz.getLocale().formatNumber(aNeu.getGebindeGewicht(),OptionFactory.NF_NORMAL))) {
				add(rz.getLocale().getString("changes.gebindegewicht"), rz.getLocale().formatNumber(aNeu.getGebindeGewicht(),OptionFactory.NF_NORMAL) ,rz.getLocale().formatNumber(aNeu.getGebindeGewicht(),OptionFactory.NF_NORMAL),rv);
			}
			if(!rz.getLocale().formatNumber(aAlt.getGebindegroesse(),OptionFactory.NF_NORMAL).equals(rz.getLocale().formatNumber(aNeu.getGebindegroesse(),OptionFactory.NF_NORMAL))) {
				add(rz.getLocale().getString("changes.gebindegroesse"), rz.getLocale().formatNumber(aNeu.getGebindegroesse(),OptionFactory.NF_NORMAL) ,rz.getLocale().formatNumber(aNeu.getGebindegroesse(),OptionFactory.NF_NORMAL),rv);
			}
			if(!aAlt.getPreis().equals(aNeu.getPreis())) {
				add(rz.getLocale().getString("changes.apreis"),rz.getLocale().formatNumber(aAlt.getPreis().doubleValue(),OptionFactory.NF_NORMAL) + " " + rz.getDatabase().getCurrency().dbGetCurrency(aAlt.getWaehrung(),true).getShortName(),rz.getLocale().formatNumber(aNeu.getPreis().doubleValue(),OptionFactory.NF_NORMAL) + " " +rz.getDatabase().getCurrency().dbGetCurrency(aNeu.getWaehrung(),true).getShortName(),rv);
			}
			if(aAlt.getWaehrung()!= aNeu.getWaehrung()) {
				add(rz.getLocale().getString("changes.awaehrung"),rz.getDatabase().getCurrency().dbGetCurrency(aAlt.getWaehrung(),true).getShortName(),rz.getDatabase().getCurrency().dbGetCurrency(aNeu.getWaehrung(),true).getShortName(),rv);
			}
		}
	}
	
	private void checkChangesNotiz() {
		if(nAlt.getID() != 0) {
			boolean rv = rz.getDatabase().getChanges().isRelevant(rezeptur_id);
			if(!nAlt.getTitel().equals(nNeu.getTitel().trim())) {
				add(rz.getLocale().getString("changes.titel"), nAlt.getTitel(), nNeu.getTitel().trim(),rv);
			}
			if(!nAlt.getComment().trim().equals(nNeu.getComment().trim())) {
				add(rz.getLocale().getString("changes.notiztext"), nAlt.getComment().trim(), nNeu.getComment().trim(),rv);
			}	
			if(!nAlt.getAdressListe().toString().equals(nNeu.getAdressListe().toString())) {
				add(rz.getLocale().getString("changes.adressliste"), nAlt.getAdressListe().toVerboseString(),nNeu.getAdressListe().toVerboseString(),rv);
			}
			if(!nAlt.getStichwortListe().toString().equals(nNeu.getStichwortListe().toString())) {
				add(rz.getLocale().getString("changes.stichwortliste"), nAlt.getStichwortListe().toVerboseString(),nNeu.getStichwortListe().toVerboseString(),rv);
			}		
		}
	}
	
	private void checkChangesRezeptur() {
		if(rAlt.getID() != 0) {
			boolean rv = rz.getDatabase().getChanges().isRelevant(rezeptur_id);
			if(!rAlt.getTitel().equals(rNeu.getTitel().trim())) {
				add(rz.getLocale().getString("changes.titel"), rAlt.getTitel(), rNeu.getTitel().trim(),rv);
			}
			if(!rAlt.getComment().trim().equals(rNeu.getComment().trim())) {
				add(rz.getLocale().getString("changes.rezeptur"), rAlt.getComment().trim(), rNeu.getComment().trim(),rv);
			}
			if(rAlt.getStaerke() != rNeu.getStaerke()) {
				add(rz.getLocale().getString("changes.staerke"), Double.toString(rAlt.getStaerke()) , Double.toString(rNeu.getStaerke()),rv);
			}
			if(rAlt.getBasismenge() != rNeu.getBasismenge()) {
				add(rz.getLocale().getString("changes.basismenge"), Double.toString(rAlt.getBasismenge()) , Double.toString(rNeu.getBasismenge()),rv);
			}
			if(rAlt.getBasiseinheit() != rNeu.getBasiseinheit()) {
				add(rz.getLocale().getString("changes.basiseinheit"),	rz.getDatabase().getEinheiten().getGrundeinheit(rAlt.getBasiseinheit()).getName() ,rz.getDatabase().getEinheiten().getGrundeinheit(rNeu.getBasiseinheit()).getName(),rv);
			}
			if(!rz.getLocale().formatNumber(rAlt.getExtrakt(),OptionFactory.NF_NORMAL).equals(rz.getLocale().formatNumber(rNeu.getExtrakt(),OptionFactory.NF_NORMAL))) {
				add(rz.getLocale().getString("changes.extrakt"), rz.getLocale().formatNumber(rAlt.getExtrakt(),OptionFactory.NF_NORMAL) ,rz.getLocale().formatNumber(rNeu.getExtrakt(),OptionFactory.NF_NORMAL),rv);
			}
			if(!rz.getLocale().formatNumber(rAlt.getLitergewicht(),OptionFactory.NF_LITERGEWICHT).equals(rz.getLocale().formatNumber(rNeu.getLitergewicht(),OptionFactory.NF_LITERGEWICHT))) {
				add(rz.getLocale().getString("changes.litergewicht"), rz.getLocale().formatNumber(rAlt.getLitergewicht(),OptionFactory.NF_LITERGEWICHT) ,rz.getLocale().formatNumber(rNeu.getLitergewicht(),OptionFactory.NF_LITERGEWICHT),rv);
			}
			if(rAlt.getExtraktfrei() != rNeu.getExtraktfrei()) {
				add(rz.getLocale().getString("changes.extraktfrei"),
						rAlt.getExtraktfrei()?rz.getLocale().getString("string_ja"):rz.getLocale().getString("string_nein"),
						rNeu.getExtraktfrei()?rz.getLocale().getString("string_ja"):rz.getLocale().getString("string_nein"),
						rv
				);
			}
			if(!rAlt.getAdressListe().toString().equals(rNeu.getAdressListe().toString())) {
				add(rz.getLocale().getString("changes.adressliste"), rAlt.getAdressListe().toVerboseString(),rNeu.getAdressListe().toVerboseString(),rv);
			}
			if(!rAlt.getStichwortListe().toString().equals(rNeu.getStichwortListe().toString())) {
				add(rz.getLocale().getString("changes.stichwortliste"), rAlt.getStichwortListe().toVerboseString(),rNeu.getStichwortListe().toVerboseString(),rv);
			}			
			if(!rAlt.getDeklarationenListe().toString().equals(rNeu.getDeklarationenListe().toString())) {
				add(rz.getLocale().getString("changes.deklarationsliste"), rAlt.getDeklarationenListe().toVerboseString(),rNeu.getDeklarationenListe().toVerboseString(),rv);
			}
			if(rAlt.getLager() != rNeu.getLager()) {
				add(rz.getLocale().getString("changes.lager"),rz.getDatabase().getLager().dbGetLager(rAlt.getLager(),true).getName(),rz.getDatabase().getLager().dbGetLager(rNeu.getLager(),true).getName(),rv);
			}
			if(!rAlt.getArtikelnummer().equals(rNeu.getArtikelnummer())) {
				add(rz.getLocale().getString("changes.artikelnummer"), rAlt.getArtikelnummer(), rNeu.getArtikelnummer(),rv);
			}
			if(!rAlt.getLosnummer().equals(rNeu.getLosnummer())) {
				add(rz.getLocale().getString("changes.losnummer"), rAlt.getLosnummer(), rNeu.getLosnummer(),rv);
			}
			if(!rz.getLocale().formatNumber(rAlt.getMeldebestand(),OptionFactory.NF_NORMAL).equals(rz.getLocale().formatNumber(rNeu.getMeldebestand(),OptionFactory.NF_NORMAL))) {
				add(rz.getLocale().getString("changes.meldebestand"), rz.getLocale().formatNumber(rAlt.getMeldebestand(),OptionFactory.NF_NORMAL) ,rz.getLocale().formatNumber(rNeu.getMeldebestand(),OptionFactory.NF_NORMAL),rv);
			}
			if(!rz.getLocale().formatNumber(rAlt.getVorschlagsbestand(),OptionFactory.NF_NORMAL).equals(rz.getLocale().formatNumber(rNeu.getVorschlagsbestand(),OptionFactory.NF_NORMAL))) {
				add(rz.getLocale().getString("changes.vorschlagsbestand"), rz.getLocale().formatNumber(rAlt.getVorschlagsbestand(),OptionFactory.NF_NORMAL) ,rz.getLocale().formatNumber(rNeu.getVorschlagsbestand(),OptionFactory.NF_NORMAL),rv);
			}
			if(rAlt.getBestandseinheit() != rNeu.getBestandseinheit()) {
				add(rz.getLocale().getString("changes.bestandseinheit"),rz.getDatabase().getEinheiten().getGrundeinheit(rAlt.getBestandseinheit()).getName() , rz.getDatabase().getEinheiten().getGrundeinheit(rNeu.getBasiseinheit()).getName(),rv);
			}
			if(!rz.getLocale().formatNumber(rAlt.getPreisMenge(),OptionFactory.NF_NORMAL).equals(rz.getLocale().formatNumber(rNeu.getPreisMenge(),OptionFactory.NF_NORMAL))) {
				add(rz.getLocale().getString("changes.preismenge"),getPreisZeile1(rAlt),getPreisZeile1(rNeu),rv);
			}
			if(!rz.getLocale().formatNumber(rAlt.getPreis(),OptionFactory.NF_NORMAL).equals(rz.getLocale().formatNumber(rNeu.getPreis(),OptionFactory.NF_NORMAL))) {
				add(rz.getLocale().getString("changes.preis"),getPreisZeile2(rAlt),getPreisZeile2(rNeu),rv);
			}
			if(rAlt.getPreisEinheit()!= rNeu.getPreisEinheit()) {
				add(rz.getLocale().getString("changes.preiseinheit"),getPreisZeile1(rAlt),getPreisZeile1(rNeu),rv);
			}
			if(rAlt.getWaehrung() != rNeu.getWaehrung()) {
				add(rz.getLocale().getString("changes.waehrung"),getPreisZeile(rAlt),getPreisZeile(rNeu),rv);
			}
			if(!rz.getLocale().formatNumber(rAlt.getSchwundsatz(),OptionFactory.NF_NORMAL).equals(rz.getLocale().formatNumber(rNeu.getSchwundsatz(),OptionFactory.NF_NORMAL))) 
			{
				add(rz.getLocale().getString("changes.schwundsatz"), rz.getLocale().formatNumber(rAlt.getSchwundsatz(),OptionFactory.NF_NORMAL) ,rz.getLocale().formatNumber(rNeu.getSchwundsatz(),OptionFactory.NF_NORMAL),rv);
			}
			if(!rz.getLocale().formatNumber(Math.abs(rAlt.getBrennwertAF()),OptionFactory.NF_NORMAL).equals(rz.getLocale().formatNumber(Math.abs(rNeu.getBrennwertAF()),OptionFactory.NF_NORMAL))) 
			{
				add(rz.getLocale().getString("changes.brennwert_af"), rz.getLocale().formatNumber(Math.abs(rAlt.getBrennwertAF()),OptionFactory.NF_NORMAL) ,rz.getLocale().formatNumber(Math.abs(rNeu.getBrennwertAF()),OptionFactory.NF_NORMAL),rv);
			}
			if(!rz.getLocale().formatNumber(Math.abs(rAlt.getAcid()),OptionFactory.NF_NORMAL).equals(rz.getLocale().formatNumber(Math.abs(rNeu.getAcid()),OptionFactory.NF_NORMAL))) 
			{
				add(rz.getLocale().getString("changes.acid"), rz.getLocale().formatNumber(Math.abs(rAlt.getAcid()),OptionFactory.NF_NORMAL) ,rz.getLocale().formatNumber(Math.abs(rNeu.getAcid()),OptionFactory.NF_NORMAL),rv);
			}
			if(!rAlt.getTank().equals(rNeu.getTank())) {
				add(rz.getLocale().getString("changes.tank"), rAlt.getTank(), rNeu.getTank(),rv);
			}
			if(!rAlt.getSpezifikation().equals(rNeu.getSpezifikation())) {
				add(rz.getLocale().getString("changes.spezifikation"), rAlt.getSpezifikation(), rNeu.getSpezifikation(),rv);
			}
			if(rAlt.isRProbe() != rNeu.isRProbe()) {
				add(rz.getLocale().getString("changes.rprobe"),rAlt.isRProbe()?rz.getLocale().getString("string_ja"):rz.getLocale().getString("string_nein"),rNeu.isRProbe()?rz.getLocale().getString("string_ja"):rz.getLocale().getString("string_nein"),rv);
			}
			if(rAlt.isBewertung() != rNeu.isBewertung()) {
				add(rz.getLocale().getString("changes.bewertung"),rAlt.isBewertung()?rz.getLocale().getString("string_ja"):rz.getLocale().getString("string_nein"),rNeu.isBewertung()?rz.getLocale().getString("string_ja"):rz.getLocale().getString("string_nein"),rv);
			}
			if(rAlt.getTempVon() != rNeu.getTempVon()) {
				add(rz.getLocale().getString("changes.tempvon"),String.valueOf(rAlt.getTempVon())+"°C",String.valueOf(rNeu.getTempVon())+"°C",rv);
			}
			if(rAlt.getTempBis() != rNeu.getTempBis()) {
				add(rz.getLocale().getString("changes.tempbis"),String.valueOf(rAlt.getTempBis())+"°C",String.valueOf(rNeu.getTempBis())+"°C",rv);
			}
			if(rAlt.isKonform() != rNeu.isKonform()) {
				if(rNeu.isKonform()) {
					add(rz.getLocale().getString("changes.konform"),
							rz.getLocale().getString("changes.konform_ja").replaceAll("%d",rAlt.getKonformDatum() == null?"":rAlt.getKonformDatum().toString()).replaceAll("%s", rAlt.getKonformComment().trim()),

							rz.getLocale().getString("changes.konform_ja").replaceAll("%d",rNeu.getKonformDatum()==null?"":rNeu.getKonformDatum().toString()).replaceAll("%s", rNeu.getKonformComment().trim())							
							,rv);
				}else {			
					add(rz.getLocale().getString("changes.konform"),
						"",
						rz.getLocale().getString("changes.konform_nein")							
						,rv);
					
				}
				if(rAlt.getKonformDatum()!= rNeu.getKonformDatum()) {
					add(rz.getLocale().getString("changes.konform"),
							rz.getLocale().getString("changes.konform_ja").replaceAll("%d",rAlt.getKonformDatum() == null?"":rAlt.getKonformDatum().toString()).replaceAll("%s", rAlt.getKonformComment().trim()),
							rz.getLocale().getString("changes.konform_ja").replaceAll("%d",rNeu.getKonformDatum() == null?"":rNeu.getKonformDatum().toString()).replaceAll("%s", rNeu.getKonformComment().trim())							
							,rv);
				}
				if(!rAlt.getKonformComment().trim().equals(rNeu.getKonformComment().trim())) {
					add(rz.getLocale().getString("changes.konform"),
							rz.getLocale().getString("changes.konform_ja").replaceAll("%d",rAlt.getKonformDatum() == null?"":rAlt.getKonformDatum().toString()).replaceAll("%s", rAlt.getKonformComment().trim()),
							rz.getLocale().getString("changes.konform_ja").replaceAll("%d",rNeu.getKonformDatum()==null?"":rNeu.getKonformDatum().toString()).replaceAll("%s", rNeu.getKonformComment().trim())							
							,rv);
				}
			}
			if(!rAlt.getSpezifikation_text().trim().equals(rNeu.getSpezifikation_text().trim())) {
				add(rz.getLocale().getString("changes.spezifikation_text"), rAlt.getSpezifikation_text(), rNeu.getSpezifikation_text(),rv);
			}
			if(!rAlt.getEan().trim().equals(rNeu.getEan().trim())) {
				add(rz.getLocale().getString("changes.ean"), rAlt.getEan(), rNeu.getEan(),rv);
			}
			if(!rAlt.getSteuerArtikel().trim().equals(rNeu.getSteuerArtikel().trim())) {
				add(rz.getLocale().getString("changes.steuerartikel"), rAlt.getSteuerArtikel(), rNeu.getSteuerArtikel(),rv);
			}
			if(rAlt.getSteuerLager() != rNeu.getSteuerLager()) {
				add(rz.getLocale().getString("changes.steuerlager"),rz.getDatabase().getRezeptur().getSteuerLager(rAlt.getSteuerLager()).getBezeichnung(),rz.getDatabase().getRezeptur().getSteuerLager(rNeu.getSteuerLager()).getBezeichnung(),rv);
			}
			if(rAlt.getSorte() != rNeu.getSorte()) {
				add(rz.getLocale().getString("changes.sorte"),rz.getDatabase().getMischungen().getSorte(rAlt.getSorte()).getBezeichnung(),rz.getDatabase().getMischungen().getSorte(rNeu.getSorte()).getBezeichnung(),rv);
			}
			if(rAlt.isAuto_anfrage() != rNeu.isAuto_anfrage()) {
				add(rz.getLocale().getString("changes.autoanfrage"),rAlt.isAuto_anfrage()?rz.getLocale().getString("string_ja"):rz.getLocale().getString("string_nein"),rNeu.isAuto_anfrage()?rz.getLocale().getString("string_ja"):rz.getLocale().getString("string_nein"), rv);
			}
			if(rAlt.getProbenAnzahl()!= rNeu.getProbenAnzahl()) {
				add(rz.getLocale().getString("changes.probenanzahl"),Integer.toString(rAlt.getProbenAnzahl()),Integer.toString(rNeu.getProbenAnzahl()) ,rv);
			}
			
		}
	}
	
	private String getPreisZeile(RezepturItem ri) {
		String ret = "";
		ret += rz.getLocale().formatNumber(ri.getPreis(),OptionFactory.NF_NORMAL) + " " +rz.getDatabase().getCurrency().dbGetCurrency(ri.getWaehrung(),true).getShortName();
		return ret;
	}

	
	private String getPreisZeile1(RezepturItem ri) {
		String ret = "";
		ret += rz.getLocale().formatNumber(ri.getPreisMenge(),OptionFactory.NF_NORMAL) + " ";
		ret += rz.getDatabase().getEinheiten().getGrundeinheit(ri.getPreisEinheit()).getName();
		return ret;
	}
	private String getPreisZeile2(RezepturItem ri) {
		String ret = "";
		ret += rz.getLocale().formatNumber(ri.getPreisMenge(),OptionFactory.NF_NORMAL) + " ";
		ret += rz.getDatabase().getEinheiten().getGrundeinheit(ri.getPreisEinheit()).getName() + " = ";
		ret += rz.getLocale().formatNumber(ri.getPreis(),OptionFactory.NF_NORMAL) + " " +rz.getDatabase().getCurrency().dbGetCurrency(ri.getWaehrung(),true).getShortName();
		return ret;
	}
	
	
}
