/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.items.rezeptur;

// eigene Pakete
import java.text.SimpleDateFormat;
import java.util.Date;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
/**
 *
 * @author  administrator
 */
public class NotizItem {

    int             id;
    String          titel;
    String          comment;
    StichwortListe  adressen;
    StichwortListe  stichworte;
    Date            erstellt;
    Date            geaendert;
    String          user_1;
    String          user_2;

    StichwortListe  adressListe;
    StichwortListe  stichwortListe;

    /** Creates a new instance of notizItem */
    public NotizItem(int aId, String aTitel, String aComment, StichwortListe aAdressListe,StichwortListe aStichwortListe,Date aErstellt,Date aGeaendert,String aUser_1,String aUser_2) {
        id = aId;
        titel = aTitel;
        comment = aComment;
        adressen = aAdressListe;
        stichworte = aStichwortListe;
        erstellt = aErstellt;
        geaendert = aGeaendert;
        user_1 = aUser_1;
        user_2 = aUser_2;
    }

    public StichwortListe getStichwortListe(){return stichworte;}
    public StichwortListe getAdressListe(){return adressen;}
    public int getID(){return id;}
    public String getTitel(){return titel;}
    public String getComment(){return comment;}
    public Date getErstellt(){return erstellt;}
    public String getErstelltToString(){
        final SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT);
        return df.format(erstellt);
    }
    public Date getGeaendert(){return geaendert;}
    public String getGeaendertToString(){
        final SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT);
        return df.format(geaendert);
    }
    public String getUser1(){return user_1;}
    public String getUser2(){return user_2;}

    public void setID(int aID){id = aID;}
    public void setTitel(String aTitel){
        titel = aTitel;
    }

    public void setComment(String aComment){
        comment = aComment;
    }

    public void setAdressListe(StichwortListe sl){
        adressen = sl;
    }
    public void setStichwortListe(StichwortListe sl){
        stichworte = sl;
    }
	/**
	 * @param erstellt The erstellt to set.
	 */
	public void setErstellt(Date erstellt) {
		this.erstellt = erstellt;
	}
	/**
	 * @param geaendert The geaendert to set.
	 */
	public void setGeaendert(Date geaendert) {
		this.geaendert = geaendert;
	}
	/**
	 * @param user_1 The user_1 to set.
	 */
	public void setUser_1(String user_1) {
		this.user_1 = user_1;
	}
	/**
	 * @param user_2 The user_2 to set.
	 */
	public void setUser_2(String user_2) {
		this.user_2 = user_2;
	}
}
