package de.lunqual.rzpro.items.rezeptur;

import de.lunqual.rzpro.RzPro;

public class RezepturBuchungsItem {

	RzPro   		        rz;
	int             		id;
	int 					typ;
	int					verweis;
	String          		titel;
	double       		staerke;
	boolean     		extraktfrei;
	double       		extrakt;
	double       		litergewicht;
	double      		bestand;
	double       		meldebestand;
	double			vorschlagsbestand;
	int					basiseinheit;
	int             		bestandseinheit;
	String          		artikelnummer;
	String          		losnummer;
	int             		lager;
	double        	schwundsatz;

	public RezepturBuchungsItem(
			RzPro        	rz,
			int            	id,
			int			 	typ,
			String        	titel,
			int				verweis,
			double     	staerke,
			boolean  	extraktfrei,
			double     	extrakt,
			double    	litergewicht,
			double 		bestand,
			double        meldebestand,
			double		vorschlagsbestand,
			int				basiseinheit,
			int             	bestandseinheit,
			String          	artikelnummer,
			String          	losnummer,
			int 	            lager,
			double       	schwundsatz
	) {
		this.rz = rz;
		this.id = id;
		this.typ=typ;
		this.titel = titel;
		this.verweis=verweis;
		this.staerke = staerke;
		this.extraktfrei = extraktfrei;
		this.extrakt = extrakt;
		this.litergewicht = litergewicht;
		this.bestand = bestand;
		this.meldebestand = meldebestand;
		this.vorschlagsbestand=vorschlagsbestand;
		this.basiseinheit=basiseinheit;
		this.bestandseinheit = bestandseinheit;
		this.artikelnummer = artikelnummer;
		this.losnummer = losnummer;
		this.lager = lager;
		this.schwundsatz = schwundsatz;
	}

	public RzPro getRz() {
		return rz;
	}

	public void setRz(RzPro rz) {
		this.rz = rz;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public int getTyp() {
		return typ;
	}

	public void setTyp(int typ) {
		this.typ = typ;
	}

	public String getTitel() {
		return titel;
	}

	public void setTitel(String titel) {
		this.titel = titel;
	}

	public double getStaerke() {
		return staerke;
	}

	public void setStaerke(double staerke) {
		this.staerke = staerke;
	}

	public boolean isExtraktfrei() {
		return extraktfrei;
	}

	public void setExtraktfrei(boolean extraktfrei) {
		this.extraktfrei = extraktfrei;
	}

	public double getExtrakt() {
		return extrakt;
	}

	public void setExtrakt(double extrakt) {
		this.extrakt = extrakt;
	}

	public double getLitergewicht() {
		return (extraktfrei) ? rz.getTafelFactory().Litergewicht(this.staerke)  : litergewicht;
	}

	public double getLitergewicht(double staerke){
		return (extraktfrei) ? rz.getTafelFactory().Litergewicht(staerke)  : litergewicht;
	}

	public void setLitergewicht(double litergewicht) {
		this.litergewicht = litergewicht;
	}

	public double getBestand() {
		return bestand;
	}

	public void setBestand(double bestand) {
		this.bestand = bestand;
	}

	public double getMeldebestand() {
		return meldebestand;
	}

	public void setMeldebestand(double meldebestand) {
		this.meldebestand = meldebestand;
	}

	public double getVorschlagsbestand() {
		return vorschlagsbestand;
	}

	public void setVorschlagsbestand(double vorschlagsbestand) {
		this.vorschlagsbestand = vorschlagsbestand;
	}

	public int getBestandseinheit() {
		return bestandseinheit;
	}

	public void setBestandseinheit(int bestandseinheit) {
		this.bestandseinheit = bestandseinheit;
	}

	public String getArtikelnummer() {
		return artikelnummer;
	}

	public void setArtikelnummer(String artikelnummer) {
		this.artikelnummer = artikelnummer;
	}

	public String getLosnummer() {
		return losnummer;
	}

	public void setLosnummer(String losnummer) {
		this.losnummer = losnummer;
	}

	public int getLager() {
		return lager;
	}

	public void setLager(int lager) {
		this.lager = lager;
	}

	public double getSchwundsatz() {
		return schwundsatz;
	}

	public void setSchwundsatz(double schwundsatz) {
		this.schwundsatz = schwundsatz;
	}

	public int getVerweis() {
		return verweis;
	}

	public void setVerweis(int verweis) {
		this.verweis = verweis;
	}

	public int getBasiseinheit() {
		return basiseinheit;
	}

	public void setBasiseinheit(int basiseinheit) {
		this.basiseinheit = basiseinheit;
	}



}
