/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.items.rezeptur;

import java.util.ArrayList;

import de.lunqual.rzpro.RzPro;
/**
 *
 * @author  lunqual
 */
public class ZutatenListe extends ArrayList {

	RzPro rz;
		
    public ZutatenListe(RzPro rz) {
    	super();
    	this.rz = rz;
    }

    public void removeItem(ZutatenSuchItem si) {
        this.remove(si);
    }

    public void addItem(ZutatenSuchItem zi){
        this.add(zi);
    }

    public ZutatenSuchItem getItem(int i){
        return (ZutatenSuchItem)this.get(i);
    }

    public ZutatenListe copyList() {
        final ZutatenListe zl = new ZutatenListe(rz);
        for(int i = 0;i< this.size();i++) {
            zl.addItem(new ZutatenSuchItem(getItem(i).getID(),getItem(i).getName(),getItem(i).getArtikelnummer(),getItem(i).getStaerke(),getItem(i).getExtrakt(),getItem(i).getLitergewicht(),getItem(i).getStichworte(),getItem(i).isBestand(),getItem(i).isMeldebestand()));
        }
        return zl;
    }

    public void setExclusive(){
    	if (this.size() > 0){
	    	for(int i = 1;i < this.size();i++){
	    		if(getItem(i).getName().trim().equals(getItem(i-1).getName().trim())){
	    			getItem(i).setExclusive(false);
	    			getItem(i-1).setExclusive(false);
	    			i++;
	    		}
	    	}
    	}
    }

    public void fromString(RzPro r,String option) {
        this.clear();
        if(!option.equals("")) {
            final String keys[] = option.split(";");
            for (final String element : keys) {
                final RezepturItem ri = r.getDatabase().getRezeptur().dbGetRezeptur(Integer.parseInt(element),true);
                if(ri != null) {
                    this.addItem(new ZutatenSuchItem(ri.getID(),ri.getTitel(),ri.getArtikelnummer(),ri.getStaerke(),ri.getExtrakt(),ri.getLitergewicht(),ri.getStichwortListe(),rz.isZero(ri.getBestand())?false:true,  rz.isZero(ri.getMeldebestand())?false:ri.getBestand() < ri.getMeldebestand()?true:false    ));
                }
            }
        }
    }

    @Override
	public String toString() {
        String ret = "";
        for(int i=0;i < size();i++) {
            ret += getItem(i).getID() + ";";
        }
        if(ret.endsWith(";")) {
			ret = ret.substring(0,ret.length()-1);
		}
        return ret;
    }
}

