/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.items.rezeptur;

import de.lunqual.rzpro.items.stichworte.StichwortListe;


/**
 *
 * @author  lunqual
 */
public class ZutatenSuchItem{

    int             id;
    String        name;
    String 		artikelnummer;
    double		staerke;
    double     extrakt;
    double 	litergewicht;
    boolean		exclusive; // gibt an, ob der Name exclusiv, d.h nur einmal existiert
    StichwortListe stichworte;
    boolean bestand;
    boolean meldebestand;
    String kugel;

    public ZutatenSuchItem(int aID,String aName,String aArtikelnummer,double aStaerke,double aExtrakt,double litergewicht,StichwortListe liste,boolean bestand,boolean meldebestand) {
        id = aID;
        name = aName;
        artikelnummer = aArtikelnummer;
        staerke = aStaerke;
        extrakt=aExtrakt;
        this.litergewicht=litergewicht;
        stichworte = liste;
        exclusive = true;
        this.bestand=bestand;
        this.meldebestand = meldebestand;
        char c = 0x25c9;
        kugel = String.valueOf(c);

        
    }

    public ZutatenSuchItem(int aID,String aName,String aArtikelnummer,double aStaerke,double aExtrakt,double litergewicht,StichwortListe liste,boolean exclusive,boolean bestand,boolean meldebestand) {
        id = aID;
        name = aName;
        artikelnummer = aArtikelnummer;
        staerke = aStaerke;
        extrakt=aExtrakt;
        this.litergewicht=litergewicht;
        stichworte = liste;
        this.exclusive = exclusive;
        this.bestand = bestand;
        this.meldebestand = meldebestand;
        char c = 0x25c9;
        kugel = String.valueOf(c);
    }
    
    public boolean isMeldebestand() {
		return meldebestand;
	}

	public void setMeldebestand(boolean meldebestand) {
		this.meldebestand = meldebestand;
	}

	public boolean isBestand() {
		return bestand;
	}

	public void setBestand(boolean bestand) {
		this.bestand = bestand;
	}

	public int getID(){return id;}
    public String getName() {return name;}
    public String getArtikelnummer(){return artikelnummer;}
    @Override
	public String toString(){
    	String color = isMeldebestand()?"orange":"green";
    	String bestand = isBestand()?"&nbsp;&nbsp;&nbsp<span style =color:\"" +color+"\"><b>&nbsp;"+kugel+"&nbsp;</b></</span>" :"";
    	if (exclusive) {
			return "<html>" + name +   " (" + artikelnummer + ")" + stichworte.toHTMLBarString() + bestand + "</html>";
		} else {
			return "<html>" +name +   " (" + artikelnummer + ")  [[" + id + "]]" + stichworte.toHTMLBarString() + bestand +"</html>" ;
		}
    }
    /** der Name existiert in der Liste nur einmal
     *
     * @return existiert einmal(true) oder mehrmals(false)
     */
    public boolean getExclusive(){
    	return exclusive;
    }
    public void setExclusive(boolean e){
    	exclusive = e;
    }

    public double getExtrakt() {
        return extrakt;
    }
    public void setExtrakt(double extrakt) {
        this.extrakt = extrakt;
    }
    public void setId(int id) {
        this.id = id;
    }
    public double getStaerke() {
        return staerke;
    }
    public void setStaerke(double staerke) {
        this.staerke = staerke;
    }
    public void setArtikelnummer(String artikelnummer) {
        this.artikelnummer = artikelnummer;
    }
    public void setName(String name) {
        this.name = name;
    }

	public StichwortListe getStichworte() {
		return stichworte;
	}
    public void setLitergewicht(double litergewicht) {
    	this.litergewicht=litergewicht;
    }
    public double getLitergewicht() {
    	return litergewicht;
    }

    public ZutatenSuchItem copyItem() {
    	return new ZutatenSuchItem(id,name,artikelnummer,staerke,extrakt,litergewicht, stichworte.copyList(),exclusive,bestand,meldebestand);
    }
}