/*
 *  Copyright (C) 2004/2005 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.items.statistik;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import javax.swing.JComboBox;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.buchungsfenster.HerstellungsFenster;
import de.lunqual.rzpro.items.lager.LagerListe;

public class StatistikItem {

	public static final int		STATISTIK_NONE						= 0;
	public static final int		STATISTIK_HERSTELLUNG				= 1;
	public static final int		STATISTIK_PLAIN						= 0;
	public static final int		STATISTIK_3D						= 1;
	public static final int		STATISTIK_MAX_FARBEN				= 24;

	WerteListe							wl;
	WerteListe							text;
	RzPro								rz;
	int									typ;
	ArrayList							combo;
	DefaultCategoryDataset				dataSet;
	JFreeChart							chart;
	String								headLine;
	String								y_Axis;
	String								x_Axis;
	String[]							monate;
	int									darstellung = STATISTIK_3D;

	int									mode;
	Date								von;
	Date								bis;
	String								bezeichnung;
	String								losnummer;
	String								user;
	String 								invers;
	LagerListe							lager;
	/**
	 * StatistikItem für Herstellungen
	 * Diese Funktion holt sich den benötigten Datensatz aus DBBuchung und
	 * erzeugt ein JFreeChart daraus
	 * @param rz
	 * @param mode
	 * @param von
	 * @param bis
	 * @param bezeichnung
	 * @param losnummer
	 */
	public StatistikItem(RzPro rz,int mode ,Date von, Date bis,String bezeichnung,String invers,String losnummer,String user,LagerListe lager) {
		this.rz = rz;
		chart = null;
		typ = STATISTIK_NONE;
		combo = new ArrayList();
		dataSet = new DefaultCategoryDataset();
		monate= new DateFormatSymbols().getMonths();
		typ = STATISTIK_HERSTELLUNG;
		darstellung = rz.getOptionFactory().getOption("st_grafik.herstellung_typ",STATISTIK_3D);
		combo.clear();
		for(int i = 0;i < 18;i++) {
			combo.add(new StatistikComboItem(
					rz.getLocale().getString("stgrafik.h" + String.valueOf(i)),
					"",
					rz.getLocale().getString("stgrafik.y" + String.valueOf(i))
			));
		}
		wl = rz.getDatabase().getBuchungen().getHerstellungsStatistik(mode,von,bis,bezeichnung,invers,losnummer,user,lager);
		this.mode=mode;
		this.von=von;
		this.bis=bis;
		this.bezeichnung=bezeichnung;
		this.losnummer=losnummer;
		this.invers=invers;
		this.lager=lager;
		this.user=user;
		x_Axis = getAuswahlString();
		text = new WerteListe();
	}

	/**
	 * gibt den String für die X-Achse zurück,
	 * wird erzeugt aus der der zugrundeliegenden Auswahl
	 * @param mode
	 * @param von
	 * @param bis
	 * @param inhalt
	 * @param losnummer
	 * @return String mit der Auswahl
	 */
	public String getAuswahlString() {
		final SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
		String strVon="-";
		String strBis="-";
		String ret =rz.getLocale().getString("stgrafik.string_auswahl.0");
		switch(mode) {
			case HerstellungsFenster.AUSWAHL_ALLE: ret += rz.getLocale().getString("stgrafik.auswahl_alle") + " ";
				break;
			case HerstellungsFenster.AUSWAHL_ERLEDIGT: ret += rz.getLocale().getString("stgrafik.auswahl_erledigt") + " ";
				break;
			case HerstellungsFenster.AUSWAHL_UNERLEDIGT: ret += rz.getLocale().getString("stgrafik.auswahl_unerledigt") + " ";
				break;
		}
		 ret += rz.getLocale().getString("stgrafik.string_auswahl.1") + " " ;
		if((von != null) && (bis != null)) {
			strVon = df.format(von);
			strBis = df.format(bis);
		}
		ret += strVon + " " + rz.getLocale().getString("stgrafik.string_auswahl.2") + " " + strBis + " " + rz.getLocale().getString("stgrafik.string_auswahl.3") + " ";
		if(bezeichnung != null ) {
			if(bezeichnung.trim().equals("")){
				ret += "- ";
			} else {
				ret += bezeichnung + " " ;
			}
		} else {
			ret += "- ";
		}
		ret += rz.getLocale().getString("stgrafik.string_auswahl.4");
		if(losnummer != null ) {
			if(losnummer.trim().equals("")){
				ret += "- ";
			} else {
				ret += losnummer + " ";
			}
		} else {
			ret += "- ";
		}
		ret += rz.getLocale().getString("stgrafik.string_auswahl.5");
		if(lager != null ) {
			ret += lager.toPlainString() + " ";
		} else {
			ret += rz.getLocale().getString("lager.liste_alle") + " ";
		}

		ret += rz.getLocale().getString("stgrafik.string_auswahl.6");
		if(invers != null ) {
			if(invers.trim().equals("")){
				ret += "- ";
			} else {
				ret += invers + " ";
			}
		} else {
			ret += "- ";
		}
		return ret;
	}

	private void  getFarben(CategoryPlot plot) {
		int i;
		 try {
			 for(i = 0; i < STATISTIK_MAX_FARBEN;i++) {
				plot.getRenderer().setSeriesPaint(i, rz.getOptionFactory().getRGBColor("stgrafik.farbe_" + String.valueOf(i)));
			}
		 }catch (final Exception e){

		 }
	}
	public WerteListe getWerteListe() {
		return wl;
	}


	/**
	 * füllt eine Combobox mit den verschiedene Statistik-Arten
	 * @param cmb	die Combobox
	 * @param selected    Index des ausgewählten Eintrags
	 */
	public void setComboBox(JComboBox cmb,int selected) {
		cmb.removeAllItems();
		for(int i = 0; i < combo.size();i++) {
			cmb.addItem(combo.get(i));
		}
		cmb.setSelectedIndex(selected);
	}

	public StatistikComboItem getComboItem(int i) {
		return (StatistikComboItem)combo.get(i);
	}

	public int getTyp() {
		return typ;
	}

	public DefaultCategoryDataset getDataset() {
		return dataSet;
	}
	/**
	 * Was muss dargestellt werden ?
	 */
	public void setDataset(int what) {
			dataSet.clear();
			switch(typ) {
				case STATISTIK_HERSTELLUNG:
					switch(what) {
						case 0:
						case 1:
						case 2:
						case 3:
						case 4:
						case 5:
							//Jahresstatistik
							if((wl != null) && (wl.size() > 0)) {
								for(int jahr =wl.getFirstYear();jahr <= wl.getLastYear();jahr++) {
									for(int monat = 1;monat < 13;monat++) {
										final WerteItem wi = wl.getItem(jahr,monat);
										dataSet.addValue(getValue(wi,what),wi.getJahrString(),wi.getMonatString());
									}
								}
							}
							break;
						case 6:
						case 7:
						case 8:
						case 9:
						case 10:
						case 11:
							//nach Monaten
							if((wl != null) && (wl.size() > 0)) {
								for(int jahr =wl.getFirstYear();jahr <= wl.getLastYear();jahr++) {
									for(int monat = 1;monat < 13;monat++) {
										final WerteItem wi = wl.getItem(jahr,monat);
										dataSet.addValue(getValue(wi,what),String.valueOf(wl.getFirstYear()) + "-" + String.valueOf(wl.getLastYear()),wi.getLabel());
									}
								}
							}
						break;
					case 12:
					case 13:
					case 14:
					case 15:
					case 16:
					case 17:
						// Jahr
						if((wl != null) && (wl.size() > 0)) {
							for(int jahr =wl.getFirstYear();jahr <= wl.getLastYear();jahr++) {
								double la_v =0.0,la_n=0.0,liter_v=0.0,liter_n=0.0,kg_v=0.0,kg_n =0.0;
								for(int monat = 1;monat < 13;monat++) {
									final WerteItem wi = wl.getItem(jahr,monat);
									la_v += wi.getLa_1();
									la_n += wi.getLa_2();
									liter_v += wi.getLiter_1();
									liter_n += wi.getLiter_2();
									kg_v += wi.getKg_1();
									kg_n += wi.getKg_2();
									WerteItem w = new WerteItem(jahr,13,liter_v,liter_n,kg_v,kg_n,la_v,la_n);
									dataSet.addValue(getValue(w,what),String.valueOf(wl.getFirstYear()) + "-" + String.valueOf(wl.getLastYear()),String.valueOf(jahr));
								}
							}
						}
					break;
							
				}
			}
	}

	public double getValue(WerteItem wi,int wert) {
		switch(wert) {
			case 0:
			case 6: 
			case 12: return Math.round(wi.getLa_1());
			case 1:
			case 7: 
			case 13: return Math.round(wi.getLa_2());
			case 2:
			case 8: 
			case 14: return Math.round(wi.getLiter_1());
			case 3:
			case 9: 
			case 15: return Math.round(wi.getLiter_2());
			case 4:
			case 10: 
			case 16: return Math.round(wi.getKg_1());
			case 5:
			case 11: 
			case 17: return Math.round(wi.getKg_2());
			default: return 0.0;
		}
	}

	/**
	 * gibt das ChartItem zurück
	 * @return JFreeChart
	 */
	public JFreeChart getChart(int what) {
		if(chart != null) {
			chart = null;
		}
		switch(typ) {
			case STATISTIK_HERSTELLUNG:
				setDataset(what);
				chart = getChartType(what);
				final org.jfree.chart.plot.CategoryPlot plot = chart.getCategoryPlot();
				final CategoryAxis domainAxis = plot.getDomainAxis();
				domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions(45));
				break;
		}
		return chart;
	}

	private JFreeChart getChartType(int what) {
		JFreeChart chart = null;
		y_Axis=((StatistikComboItem)combo.get(what)).getY_Axis();
		switch (darstellung ) {
			case STATISTIK_3D:
				chart= ChartFactory.createBarChart3D(
						((StatistikComboItem)combo.get(what)).getHeadLine(),
						x_Axis,
						y_Axis,
						dataSet,
						PlotOrientation.VERTICAL,
						true,true,false
				);
				break;
			case STATISTIK_PLAIN:
				chart= ChartFactory.createBarChart(
						((StatistikComboItem)combo.get(what)).getHeadLine(),
						x_Axis,
						y_Axis,
						dataSet,
						PlotOrientation.VERTICAL,
						true,true,false
				);
				break;
		}
		 final CategoryPlot plot = chart.getCategoryPlot();
		 getFarben(plot);
		return chart;
	}


	public void setDarstellung(int darstellung) {
		this.darstellung = darstellung;
	}
	public int getDarstellung() {
		return darstellung;
	}

}


