/*
 *  Copyright (C) 2004/2005 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.items.statistik;

import java.text.DateFormatSymbols;

public class WerteItem {
	int				monat;
	int				jahr;
	double			liter_1;
	double			liter_2;
	double			kg_1;
	double			kg_2;
	double			la_1;
	double			la_2;
	String			label;

	public WerteItem(int jahr,int monat, double liter_1,double liter_2,double kg_1,double kg_2,double la_1,double la_2) {
		this.monat=monat;
		this.jahr=jahr;
		this.liter_1=liter_1;
		this.liter_2=liter_2;
		this.kg_1=kg_1;
		this.kg_2=kg_2;
		this.la_1=la_1;
		this.la_2=la_2;
		if(monat >0 && monat<13) {
			label = new DateFormatSymbols().getMonths()[monat-1];
		} else {
			label ="";
		}
	}

	public String getJahrString() {
		return String.valueOf(jahr);
	}

	public String getMonatString() {
		return label;
	}
	public int getJahr() {
		return jahr;
	}
	public double getKg_1() {
		return kg_1;
	}
	public double getKg_2() {
		return kg_2;
	}
	public double getLa_1() {
		return la_1;
	}
	public double getLa_2() {
		return la_2;
	}
	public double getLiter_1() {
		return liter_1;
	}
	public double getLiter_2() {
		return liter_2;
	}
	public int getMonat() {
		return monat;
	}

	public String getLabel() {
		return  getMonatString() + " " + String.valueOf(jahr) ;
	}

}
