/*
 *  Copyright (C) 2004/2005 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.items.statistik;

import java.util.ArrayList;
import java.util.HashMap;

public class WerteListe extends ArrayList{

	HashMap	werteMap;

	public WerteListe() {
		super();
		werteMap = new HashMap();
	}

	public void addItem(WerteItem wi) {
		this.add(wi);
		werteMap.put(String.valueOf(wi.getJahr()) + ":" + String.valueOf(wi.getMonat()),wi);
	}

	public WerteItem getItem(int i) {
		return (WerteItem)this.get(i);
	}

	public WerteItem getItem(int jahr,int monat) {
	    return (WerteItem)werteMap.get(String.valueOf(jahr)+":"+String.valueOf(monat)) == null ?
	    		new WerteItem(jahr,monat,0,0,0,0,0,0) :
	    		(WerteItem)werteMap.get(String.valueOf(jahr)+":"+String.valueOf(monat));
	}
	/**
	 * das früheste Jahr in der Liste zurückgeben
	 * @return Jahr, oder -1 wenn die Liste leer ist
	 */
	public int getFirstYear() {
		final int ret = -1;
		if(!this.isEmpty()) {
			return this.getItem(0).getJahr();
		}
		return ret;
	}
	/**
	 * das letze Jahr in der Liste zurückgeben
	 * @return Jahr, oder -1 wenn die Liste leer ist
	 */
	public int getLastYear() {
		final int ret = -1;
		if(!this.isEmpty()) {
			return this.getItem(this.size()-1).getJahr();
		}
		return ret;
	}

	public int getColumnCount() {
		return getLastYear() - getFirstYear();
	}

}
