package de.lunqual.rzpro.items.temperaturzone;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;


public class rezepturZonenListe extends ArrayList{

    private final Collator        		coll;
    private final Comparator      		compZone;
    private final Comparator      		compZoneReverse;
    private final Comparator			compRezeptur;
    private final Comparator			compRezepturReverse;
    
	public rezepturZonenListe() {
		super();
        coll = Collator.getInstance(Locale.getDefault());
        compZone = new Comparator()
        {
            public int compare(Object o1,Object o2){
                final String s1 = ((rezepturZonenItem)o1).getZi().getBezeichnung();
                final String s2 = ((rezepturZonenItem)o2).getZi().getBezeichnung();
                return coll.compare(s1,s2);
            }
        };
        compZoneReverse = new Comparator()
        {
            public int compare(Object o1,Object o2){
                final String s1 = ((rezepturZonenItem)o1).getZi().getBezeichnung();
                final String s2 = ((rezepturZonenItem)o2).getZi().getBezeichnung();
                return coll.compare(s2,s1);
            }
        };
        compRezepturReverse = new Comparator()
        {
            public int compare(Object o1,Object o2){
                final String s1 = ((rezepturZonenItem)o1).getBezeichnung();
                final String s2 = ((rezepturZonenItem)o2).getBezeichnung();
                return coll.compare(s2,s1);
            }
        };
        compRezeptur = new Comparator()
        {
            public int compare(Object o1,Object o2){
                final String s1 = ((rezepturZonenItem)o1).getBezeichnung();
                final String s2 = ((rezepturZonenItem)o2).getBezeichnung();
                return coll.compare(s1,s2);
            }
        };
	}
	
	public void addItem(temperaturZonenItem tzi) {
		this.add(tzi);
		
	}
	
	public rezepturZonenItem getItem(int i) {
		return (rezepturZonenItem)this.get(i);
	}
	
	public void sortZone() {
		Collections.sort(this,compZone);
	}
	public void sortZoneReverse() {
		Collections.sort(this,compZoneReverse);
	}
	public void sortRezeptur() {
		Collections.sort(this,compRezeptur);
	}
	public void sortRezepturReverse() {
		Collections.sort(this,compRezepturReverse);
	}
}
