package de.lunqual.rzpro.items.trace;

import de.lunqual.rzpro.RzPro;

public class TraceLineItem {
	
	public static final int LEVEL_STEP = 4;
			
	RzPro			rz;
	int				typ;
	int				level;
	String			text;
	int				level_step;

	public TraceLineItem(RzPro rz,int typ,int level,String text) {
		this.rz = rz;
		this.typ = typ;
		this.level = level;
		this.text = text;
		level_step = rz.getOptionFactory().getOption("trace.level.step", LEVEL_STEP);
	}

	public int getTyp() {
		return typ;
	}

	public void setTyp(int typ) {
		this.typ = typ;
	}

	public int getLevel() {
		return level;
	}

	public void setLevel(int level) {
		this.level = level;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public String toString() {
		String prefix = "";
		for(int i=0;i < (level*level_step);i++) {
			prefix += " ";
		}
		return prefix + text.replaceAll("\\<.*?>","");
	}
	
	public String toHTMLString() {
		String prefix = "";
		for(int i=0;i < (level*level_step);i++) {
			prefix += "&nbsp;&nbsp;";
		}
		return prefix + text;
	}
	
}
