/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.localefactory;
// eigene Pakete
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.ResourceBundle;


import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.log.LogFactory;
import de.lunqual.rzpro.options.OptionFactory;

/**
 * verwaltet die locale-spezifischen DAten, d.H. die verschiedensprachigen
 * Texte und Zahlenformate
 * @author lunqual
 */
public class LocaleFactory {

    public static final String      LOCALE_PATH  	      	= "de/lunqual/rzpro/locale/";
    public static final String      LOCALE_FILE      	   	= "rzlocale";
    public static final String      FENSTER_FILE         	= "rzwindows.properties";

    public static final int			TAFEL_2_PRECISION 	= 1;
    public static final int			TAFEL_3_PRECISION 	= 2;
    public static final int			TAFEL_6_PRECISION 	= 6;

    RzPro           rz;
    ResourceBundle  sprache;
    Locale          rzLocale;
    String          localeFileName;



    //NumberFormat

    NumberFormat			nfOne;
    NumberFormat			nfTwo;
    NumberFormat        	nfNormal;
    NumberFormat        	nfLitergewicht;
    NumberFormat        	nfStaerke;
    NumberFormat		 	nfExchange;
    NumberFormat		 	nfLieferschein;
    NumberFormat			nfInventur;
    NumberFormat			nfTafel2;
    NumberFormat		 	nfTafel3;
    NumberFormat		 	nfTafel6;

    /** Creates a new instance of LocaleControl */
    public LocaleFactory(RzPro r) {
        rz = r;
        setLocale();
        nfOne = NumberFormat.getNumberInstance();
        nfTwo = NumberFormat.getNumberInstance();
        nfNormal = NumberFormat.getNumberInstance();
        nfLitergewicht = NumberFormat.getNumberInstance();
        nfStaerke = NumberFormat.getNumberInstance();
        nfExchange = NumberFormat.getNumberInstance();
        nfLieferschein = NumberFormat.getNumberInstance();
        nfInventur = NumberFormat.getNumberInstance();
        nfTafel2=NumberFormat.getNumberInstance();
        nfTafel3=NumberFormat.getNumberInstance();
        nfTafel6=NumberFormat.getNumberInstance();

        createNumberFormats();
    }

    private void setLocale(){
    	/**
    	 * Die nächste Zeile bewirkt, dass das Programm AUSCHLIESSLICH
    	 * auf Englisch läuft !
    	 * 
    	 * Dazu muss im Ordner de/lunqual/rzpro/locale die Datei
    	 * rzlocale_en.properties vorhanden sein, auf die dann als
    	 * Sprachdatei zurückgegriffen wird.
    	 */
    	//Locale.setDefault(Locale.ENGLISH);
    	Locale.setDefault(Locale.GERMANY);
    	/**
    	 * Normalerweise sollte die obere Zeile auskommentiert sein,
    	 * d.h. sie sollte mit // beginnen
    	 * Wenn nicht, dann wird zwangsweise die englische Sprache voreingestellt !
    	 */
    	rzLocale = Locale.getDefault();
        rz.getLogFactory().logMessage(1, "LocaleControl.setLocale:", rzLocale.toString());
        localeFileName = rz.getOptionFactory().getOption("localecontrol.path") + rz.getOptionFactory().getOption("localecontrol.file");
        sprache = ResourceBundle.getBundle(localeFileName);
    }


    /** erzeugt die verschiedenen Zahlenformate
     * wird auch von OptionControl aufgerufen !!!
     */
    public void createNumberFormats(){
        nfNormal.setMinimumFractionDigits(rz.getOptionFactory().getOption("nff.normal_f_min", 1));
        nfNormal.setMaximumFractionDigits(rz.getOptionFactory().getOption("nff.normal_f_max", 4));
        nfNormal.setMinimumIntegerDigits(rz.getOptionFactory().getOption("nff.normal_i_min", 1));
        nfNormal.setMaximumIntegerDigits(rz.getOptionFactory().getOption("nff.normal_i_max", 99));
        rz.getOptionFactory().setOption("report.zahlen_normal", rz.getOptionFactory().getNumberFormatString(nfNormal));

        nfOne.setMinimumFractionDigits(rz.getOptionFactory().getOption("nff.one_f_min", 0));
        nfOne.setMaximumFractionDigits(rz.getOptionFactory().getOption("nff.one_f_max", 0));
        nfOne.setMinimumIntegerDigits(rz.getOptionFactory().getOption("nff.one_i_min", 1));
        nfOne.setMaximumIntegerDigits(rz.getOptionFactory().getOption("nff.one_i_max", 99));
        rz.getOptionFactory().setOption("report.zahlen_one", rz.getOptionFactory().getNumberFormatString(nfOne));

        nfTwo.setMinimumFractionDigits(rz.getOptionFactory().getOption("nff.two_f_min", 0));
        nfTwo.setMaximumFractionDigits(rz.getOptionFactory().getOption("nff.two_f_max", 2));
        nfTwo.setMinimumIntegerDigits(rz.getOptionFactory().getOption("nff.two_i_min", 1));
        nfTwo.setMaximumIntegerDigits(rz.getOptionFactory().getOption("nff.two_i_max", 99));
        rz.getOptionFactory().setOption("report.zahlen_two", rz.getOptionFactory().getNumberFormatString(nfTwo));


        nfLitergewicht.setMinimumFractionDigits(rz.getOptionFactory().getOption("nff.litergewicht_f_min",6));
        nfLitergewicht.setMaximumFractionDigits(rz.getOptionFactory().getOption("nff.litergewicht_f_max",6));
        nfLitergewicht.setMinimumIntegerDigits(rz.getOptionFactory().getOption("nff.litergewicht_i_min",1));
        nfLitergewicht.setMaximumIntegerDigits(rz.getOptionFactory().getOption("nff.litergewicht_i_max",1));
        rz.getOptionFactory().setOption("report.zahlen_litergewicht", rz.getOptionFactory().getNumberFormatString(nfLitergewicht));

        nfStaerke.setMinimumFractionDigits(rz.getOptionFactory().getOption("nff.staerke_f_min", 1));
        nfStaerke.setMaximumFractionDigits(rz.getOptionFactory().getOption("nff.staerke_f_max", 2));
        nfStaerke.setMinimumIntegerDigits(rz.getOptionFactory().getOption("nff.staerke_i_min", 1));
        nfStaerke.setMaximumIntegerDigits(rz.getOptionFactory().getOption("nff.staerke_i_max", 2));
        rz.getOptionFactory().setOption("report.zahlen_staerke", rz.getOptionFactory().getNumberFormatString(nfStaerke));

        nfExchange.setMinimumFractionDigits(rz.getOptionFactory().getOption("nff.exchange_f_min", 1));
        nfExchange.setMaximumFractionDigits(rz.getOptionFactory().getOption("nff.exchange_f_max", 6));
        nfExchange.setMinimumIntegerDigits(rz.getOptionFactory().getOption("nff.exchange_i_min", 1));
        nfExchange.setMaximumIntegerDigits(rz.getOptionFactory().getOption("nff.exchange_i_max", 99));
        rz.getOptionFactory().setOption("report.zahlen_exchange", rz.getOptionFactory().getNumberFormatString(nfExchange));

        nfLieferschein.setMinimumFractionDigits(rz.getOptionFactory().getOption("nff.lieferschein_f_min", 1));
        nfLieferschein.setMaximumFractionDigits(rz.getOptionFactory().getOption("nff.lieferschein_f_max", 2));
        nfLieferschein.setMinimumIntegerDigits(rz.getOptionFactory().getOption("nff.lieferschein_i_min", 1));
        nfLieferschein.setMaximumIntegerDigits(rz.getOptionFactory().getOption("nff.lieferschein_i_max", 2));
        rz.getOptionFactory().setOption("report.zahlen_lieferschein", rz.getOptionFactory().getNumberFormatString(nfLieferschein));

        nfInventur.setMinimumFractionDigits(rz.getOptionFactory().getOption("nff.inventur_f_min",6));
        nfInventur.setMaximumFractionDigits(rz.getOptionFactory().getOption("nff.inventur_f_max",6));
        nfInventur.setMinimumIntegerDigits(rz.getOptionFactory().getOption("nff.inventur_i_min",1));
        nfInventur.setMaximumIntegerDigits(rz.getOptionFactory().getOption("nff.inventur_i_max",1));
        rz.getOptionFactory().setOption("report.zahlen_inventur", rz.getOptionFactory().getNumberFormatString(nfInventur));

        nfTafel2.setMinimumFractionDigits(TAFEL_2_PRECISION);
        nfTafel2.setMinimumFractionDigits(TAFEL_2_PRECISION);
        rz.getOptionFactory().setOption("report.zahlen_tafel2", rz.getOptionFactory().getNumberFormatString(nfTafel2));
        nfTafel3.setMinimumFractionDigits(TAFEL_3_PRECISION);
        nfTafel3.setMaximumFractionDigits(TAFEL_3_PRECISION);
        rz.getOptionFactory().setOption("report.zahlen_tafel3", rz.getOptionFactory().getNumberFormatString(nfTafel3));
        nfTafel6.setMinimumFractionDigits(TAFEL_6_PRECISION);
        nfTafel6.setMaximumFractionDigits(TAFEL_6_PRECISION);
        nfTafel6.setMinimumIntegerDigits(1);
        nfTafel6.setMaximumIntegerDigits(1);
        rz.getOptionFactory().setOption("report.zahlen_tafel6", rz.getOptionFactory().getNumberFormatString(nfTafel6));
    }


    /**
     * String getString(String) liefert einen Locale-String
     * @param key der Schlüssel
     * @return der passende Locale-String zum Key oder den key in * eingeschlossen,
     * wenn nichts gefunden wurde
     */
    public String getString(String key){
    	String ret = "";
        try {

            ret = sprache.getString(key);
        }
        catch (final Exception e){
            rz.getLogFactory().logMessage(1, "LocaleControl.getString:", key);
            if(key.endsWith(".1")) {
            	ret = key.substring(key.length() - ".1".length());
            } else {
            	ret = key;
            }
        }
        return ret;
    }

    /**
     * getMnemonic liefert einen Integer Wert aus einem Key oder 0,
     * wenn der Key nicht vorhanden oder leer ist
     */

    public Integer getMnemonic(String key){
        final String m = getString(key);
        if (!m.equals("")){
            return Integer.valueOf(m.charAt(0));
        }
		return Integer.valueOf(0);
    }

    /** boolean isNumber(String) prüft, ob der String eine gültige Zahl repräsentiert
     * und gibt true zurück, wenn ja, der Stern '*' gilt übrigens als gültige Zahl !!!
     */
    public boolean isNumber(String aString){
        boolean ret = false;
        if(aString.equals("*")){
            ret = true;
        }
        else {
            try{
                /* wir versuchen, den String in eine Zahl zu casten
                 * Wenn das funktioniert ist es wohl eine Zahl, wenn
                 * nicht, wird eine Exception geworfen...
                 */
                nfNormal.parse(aString);
                ret = true;
            }
            catch(final ParseException e){
                ret = false;
            }
        }
        return ret;
    }

    /** getNumberFormat(int) liefert ein vordefiniertes Zahlenformat
     */
    public NumberFormat getNumberFormat(int n){
        switch(n){
        	case OptionFactory.NF_ONE:return nfOne;
        	case OptionFactory.NF_TWO:return nfTwo;
            case OptionFactory.NF_LITERGEWICHT: return nfLitergewicht;
            case OptionFactory.NF_STAERKE: return nfStaerke;
            case OptionFactory.NF_NORMAL: return nfNormal;
            case OptionFactory.NF_EXCHANGE : return nfExchange;
            case OptionFactory.NF_LIEFERSCHEIN: return nfLieferschein;
            case OptionFactory.NF_INVENTUR:return nfInventur;
            case OptionFactory.NF_TAFEL_2:return nfTafel2;
            case OptionFactory.NF_TAFEL_3:return nfTafel3;
            case OptionFactory.NF_TAFEL_6:return nfTafel6;
        }
        return null;
    }

    /** formatNumber(double aNumber,int aFormat) gibt eine
     * formatierte Zahl als String zurück
     */
    public String formatNumber(double aNumber,int aFormat){
        String ret = "";
        NumberFormat nf = null;
        switch(aFormat) {
            case OptionFactory.NF_NORMAL: nf = nfNormal;
                break;
            case OptionFactory.NF_LITERGEWICHT: nf = nfLitergewicht;
                break;
            case OptionFactory.NF_STAERKE: nf = nfStaerke;
                break;
            case OptionFactory.NF_EXCHANGE: nf = nfExchange;
            	break;
            case OptionFactory.NF_LIEFERSCHEIN: nf = nfLieferschein;
        		break;
            case OptionFactory.NF_INVENTUR: nf = nfInventur;
    			break;
            case OptionFactory.NF_TAFEL_2: nf = nfTafel2;
    			break;
            case OptionFactory.NF_TAFEL_3: nf = nfTafel3;
				break;
            case OptionFactory.NF_TAFEL_6: nf = nfTafel6;
				break;
            case OptionFactory.NF_ONE: nf = nfOne;
				break;
            case OptionFactory.NF_TWO: nf = nfTwo;
				break;
        }
        if (nf != null){
        	try {
        		ret = nf.format(aNumber);
        	}
        	catch (final Exception e){
        		rz.getLogFactory().logMessage(1, "LocaleControl:formatNumber:Double", e.getLocalizedMessage());
        		ret = "0";
        	}
        }
        return ret;
    }
    /**
     * liefert eine double-zahl aus einem locale-formatierten string
     * @param aNumber die zahl als string
     * @param aFormat numberformat aus Optioncontrol
     * @return double value oder 0.0, wenn keine gültige Zahl vorliegt
     */
    public double getNumber(String aNumber,int aFormat) {
        double ret = 0;
        try {
            ret = (getNumberFormat(aFormat).parse(aNumber)).doubleValue();
        }catch (final ParseException e) {
            ret = 0;
        }
        return ret;
    }

    public String formatNumber(BigDecimal aNumber,int aFormat){
        String ret = "";
        NumberFormat nf = null;
        switch(aFormat) {
            case OptionFactory.NF_NORMAL: nf = nfNormal;
                break;
            case OptionFactory.NF_LITERGEWICHT: nf = nfLitergewicht;
                break;
            case OptionFactory.NF_STAERKE: nf = nfStaerke;
                break;
            case OptionFactory.NF_EXCHANGE: nf = nfExchange;
        		break;
            case OptionFactory.NF_LIEFERSCHEIN: nf = nfLieferschein;
    			break;
            case OptionFactory.NF_INVENTUR: nf = nfInventur;
				break;
            case OptionFactory.NF_TAFEL_2: nf = nfTafel2;
				break;
            case OptionFactory.NF_TAFEL_3: nf = nfTafel3;
				break;
            case OptionFactory.NF_TAFEL_6: nf = nfTafel6;
				break;
            case OptionFactory.NF_ONE: nf = nfOne;
			break;
        }
        if (nf != null){
        	try {
        		ret = nf.format(aNumber);
        	} catch(final IllegalArgumentException e) {
        		ret = "0";
        		rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"LocaleControl.formatNumber.BigDecimal",e.getLocalizedMessage()+ ":" + aNumber);
        	}
        }
        return ret;
    }

    public String formatNumber(String aString,int aFormat){
        String ret = "";
        NumberFormat nf = null;
        switch(aFormat) {
            case OptionFactory.NF_NORMAL: nf = nfNormal;
                break;
            case OptionFactory.NF_LITERGEWICHT: nf = nfLitergewicht;
                break;
            case OptionFactory.NF_STAERKE: nf = nfStaerke;
                break;
            case OptionFactory.NF_EXCHANGE: nf = nfExchange;
        		break;
            case OptionFactory.NF_INVENTUR: nf = nfInventur;
				break;
            case OptionFactory.NF_LIEFERSCHEIN: nf = nfLieferschein;
    			break;
            case OptionFactory.NF_TAFEL_2: nf = nfTafel2;
				break;
            case OptionFactory.NF_TAFEL_3: nf = nfTafel3;
				break;
            case OptionFactory.NF_TAFEL_6: nf = nfTafel6;
				break;
            case OptionFactory.NF_ONE: nf = nfOne;
			break;
        }
        if (nf != null){
            try {
                ret = nf.format(nf.parse(aString.trim()));
            }
            catch (final ParseException e){
            	ret = "0";
           		rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"LocaleControl.formatNumber.String",e.getLocalizedMessage());
            }
        }
        return ret;
    }

    

    
    

}
