/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.log;
// eigene Pakete

import java.util.Date;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.items.log.LoggingItem;
import de.lunqual.rzpro.items.log.LoggingListe;
import de.lunqual.rzpro.items.message.MessageItem;

/**
 * stellt einfache logging-funktionalität zur
 * Verfügung
 * @author lunqual
 */

public class LogFactory {

    public static final int         LOG_NOTHING        	= 0;
    public static final int         DEFAULT_LEVEL    	= 9999;
    public static final int         LOG_ALL             	= 9999;
    public static final int         LOG_MESSAGE      = 1;
    public static final int         LOG_WARN            	= 2;
    public static final int         LOG_ERROR           	= 3;

    public static final int		  DEFAULT_COUNT		= 200;

    RzPro           	rz;
    LoggingListe	liste;
    int				logCount = DEFAULT_COUNT;

    JRzFrame		notify;
    MessageItem msg;

    /**
     * alle Messages <= logLevel werden ausgegeben
     */
    int             logLevel = DEFAULT_LEVEL;



    /** Creates a new instance of LogControl */
    public LogFactory(RzPro r) {
        rz = r;
        msg = new MessageItem(MessageItem.MSG_LOG_CHANGE, 0,null,null);
        liste = new LoggingListe(rz,DEFAULT_COUNT);
    }

    /**
     * festlegen, wer zu benachrichtigen ist, wenn sich die Liste
     * ändert
     */

    public void setNotifyFrame(JRzFrame f) {
    	this.notify=f;
    }
    /**
     * Logging auf Defaultwerte setzen... Das geht nicht gleich im Constructor,
     * weil da noch kein OptionControl existiert
     */
    public void initLog() {
        setLogLevel(rz.getOptionFactory().getOption("log.level",DEFAULT_LEVEL));
        setLogCount(rz.getOptionFactory().getOption("log.level",DEFAULT_COUNT));
        logMessage(LOG_MESSAGE,"LogControl","Start Log:" + new Date().toString());
        logMessage(LOG_MESSAGE,"LogControl" , rz.getVersionString());
    }
    /** Log-Count setzen
     *
     * @param count
     */
    public void setLogCount(int count){
        logCount=count;
        liste.setMaxCount(logCount);
    }

    /** Log-Level setzen
     *
     * @param level
     */
    public void setLogLevel(int level){
        logLevel = level;
    }
    /** eine Meldung loggen
     *
     * @param level int LOG_WARN/ERROR
     * @param origin String  Object, das den Fehler verursacht hat
     * @param message String MessageText
     */
    public void logMessage(int level,String origin,String message){
        if (level <= logLevel){
            System.out.println(origin + ":" + message);
        }
        liste.addItem(new LoggingItem(rz,level,origin,message));
        if(notify != null) {
        	try {
        		notify.getMessage(msg);
        	} catch (final Exception e) {

        	}
        }
    }
    /**
     * Die LogginListe zurückgeben
     * @return LoggingListe
     */
    public LoggingListe getLog() {
    	return liste;
    }
}
