/*
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */


package de.lunqual.rzpro.options;
// eigene Pakete
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Properties;

import javax.swing.Icon;
import javax.swing.text.MaskFormatter;


import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.AdressenAusgabeDrucken;
import de.lunqual.rzpro.ausgabe.AuftragslisteDrucken;
import de.lunqual.rzpro.ausgabe.AusstattungCalcDrucken;
import de.lunqual.rzpro.ausgabe.AusstattungRawDrucken;
import de.lunqual.rzpro.ausgabe.BestellungslisteDrucken;
import de.lunqual.rzpro.ausgabe.BewertungDrucken;
import de.lunqual.rzpro.ausgabe.ChangesDrucken;
import de.lunqual.rzpro.ausgabe.ErgebnislisteAusgabeDrucken;
import de.lunqual.rzpro.ausgabe.ErgebnislisteBestandDrucken;
import de.lunqual.rzpro.ausgabe.HerstellungDrucken;
import de.lunqual.rzpro.ausgabe.InventurDrucken;
import de.lunqual.rzpro.ausgabe.KonformDrucken;
import de.lunqual.rzpro.ausgabe.LaborwertDrucken;
import de.lunqual.rzpro.ausgabe.LagerBestandDrucken;
import de.lunqual.rzpro.ausgabe.LagerListeDrucken;
import de.lunqual.rzpro.ausgabe.MischungDrucken;
import de.lunqual.rzpro.ausgabe.MischungslisteDrucken;
import de.lunqual.rzpro.ausgabe.NotizAusgabeDrucken;
import de.lunqual.rzpro.ausgabe.RechenBlattDrucken;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.ausgabe.RezepturAusgabeDrucken;
import de.lunqual.rzpro.ausgabe.StatistikDrucken;
import de.lunqual.rzpro.ausgabe.TemperaturzonenDrucken;
import de.lunqual.rzpro.ausgabe.TraceDrucken;
import de.lunqual.rzpro.ausgabe.VerlaufDrucken;
import de.lunqual.rzpro.ausgabe.ZutatenlisteDrucken;
import de.lunqual.rzpro.database.DBBuchung;
import de.lunqual.rzpro.database.DBFactory;
import de.lunqual.rzpro.database.DBKalender;
import de.lunqual.rzpro.database.DBOptionen;
import de.lunqual.rzpro.fenster.ZutatenDialog;
import de.lunqual.rzpro.fenster.Stammbaumfenster.stammbaumPanel;
import de.lunqual.rzpro.fenster.lagerfenster.Lager;
import de.lunqual.rzpro.fonts.FontFactory;
import de.lunqual.rzpro.items.kalender.KalenderItem;
import de.lunqual.rzpro.items.options.SortedProperties;
import de.lunqual.rzpro.items.statistik.StatistikItem;
import de.lunqual.rzpro.items.trace.TraceItem;
import de.lunqual.rzpro.items.trace.TraceLineItem;
import de.lunqual.rzpro.localefactory.LocaleFactory;
import de.lunqual.rzpro.log.LogFactory;


/**
 * Liest und schreibt per-User Optionen in eine Datei im
 * Homeverzeichnis des Users
 * @author administrator
 */
public class OptionFactory {

	public static final int				DEFAULT_INACTIVITY_TIMEOUT = 10;
	
    // const
	//AUswahl
	public static final int				BESTANDSWARNUNGS_INTERVAL=60;
	public static final int				BESTANDSWARNUNGS_ZUTATEN=0;
	public static final int				BESTANDSWARNUNGS_BUCHUNGEN=0;
	public static final int				BESTANDSWARNUNG_STATUS_0=-7;
	public static final int				BESTANDSWARNUNG_STATUS_1=-14;
	public static final int				BESTANDSWARNUNG_STATUS_2=-21;
	public static final String			BESTANDSWARNUNG_STATUS_COLOR_0="00ff00";
	public static final String			BESTANDSWARNUNG_STATUS_COLOR_1="ffff00";
	public static final String			BESTANDSWARNUNG_STATUS_COLOR_2="ffaa00";
	public static final String			BESTANDSWARNUNG_STATUS_COLOR_3="ff0000";
	public static final int				AUFTRAGSLISTE_INTERVAL=10;
	public static final int				ANFRAGENLISTE_INTERVAL=10;
	
	public static final int				AUSWAHL_DICHTE_ANZEIGEN = 1;

	//Auswahl
	public static final int				AUSWAHL_ABFRAGELISTE_MAX=20;

    // OptionControl
    public static final String      	OPTION_FOLDER       = ".rzpro";
    public static final String      	OPTION_FILE         = "rzoptions.properties";
    // Zahlenformate
    public static final int         	NF_LITERGEWICHT  	= 1;
    public static final int         	NF_STAERKE         	= 2;
    public static final int        		NF_NORMAL           = 3;
    public static final int				NF_EXCHANGE			= 4;
    public static final int				NF_LIEFERSCHEIN		= 5;
    public static final int				NF_TAFEL_2			= 6;
    public static final int				NF_TAFEL_3			= 7;
    public static final int				NF_TAFEL_6			= 8;
    public static final int				NF_INVENTUR			= 9;
    public static final int				NF_ONE				= 10;
    public static final int				NF_TWO				= 11;
    
    /** NFF Anzahl der Vorkomma-(Integer) I_MIN und I_MAX Stellen und
     * Nachkomma (Fraction) F_MIN und F_MAX Stellen
     */
    public static final int         	NFF_NORMAL_I_MIN  	= 1;
    public static final int         	NFF_NORMAL_I_MAX  	= 99;
    public static final int         	NFF_NORMAL_F_MIN 	= 1;
    public static final int         	NFF_NORMAL_F_MAX  = 4;

    public static final int         	NFF_LITERGEWICHT_I_MIN  	= 1;
    public static final int         	NFF_LITERGEWICHT_I_MAX  	= 1;
    public static final int         	NFF_LITERGEWICHT_F_MIN  	= 6;
    public static final int         	NFF_LITERGEWICHT_F_MAX  	= 6;

    public static final int         	NFF_STAERKE_I_MIN 	 	= 1;
    public static final int         	NFF_STAERKE_I_MAX  	= 2;
    public static final int         	NFF_STAERKE_F_MIN  	= 1;
    public static final int         	NFF_STAERKE_F_MAX  	= 2;

    public static final int         	NFF_EXCHANGE_I_MIN  	= 1;
    public static final int         	NFF_EXCHANGE_I_MAX  	= 99;
    public static final int         	NFF_EXCHANGE_F_MIN  	= 1;
    public static final int         	NFF_EXCHANGE_F_MAX  = 6;

    public static final int         	NFF_LIEFERSCHEIN_I_MIN 	 	= 1;
    public static final int         	NFF_LIEFERSCHEIN_I_MAX  	= 99;
    public static final int         	NFF_LIEFERSCHEIN_F_MIN  	= 1;
    public static final int         	NFF_LIEFERSCHEIN_F_MAX  	= 1;

    public static final int         	NFF_INVENTUR_I_MIN  	= 1;
    public static final int         	NFF_INVENTUR_I_MAX  	= 99;
    public static final int         	NFF_INVENTUR_F_MIN 	= 1;
    public static final int         	NFF_INVENTUR_F_MAX  = 1;
    
    public static final int         	NFF_ONE_I_MIN  	= 1;
    public static final int         	NFF_ONE_I_MAX  	= 99;
    public static final int         	NFF_ONE_F_MIN 	= 0;
    public static final int         	NFF_ONE_F_MAX  = 0;
    
    

    public static final int			NFF_MAX_STRING					= 32;

    //Farben
    public static final int			COLOR_BESTAND_WHITE =0;
    public static final int			COLOR_BESTAND_GRUEN=1;
    public static final int			COLOR_BESTAND_GELB=2;
    public static final int			COLOR_BESTAND_ROT=3;
    public static final int			COLOR_SELECTION_FOREGROUND 	= 4;
    public static final int			COLOR_SELECTION_BACKGROUND = 5;
    public static final int			COLOR_TEXT_HIGHLIGHT_BACKGROUND = 6;
    public static final int			COLOR_TEXT_HIGHLIGHT_FOREGROUND = 7;
    public static final int			COLOR_TEXT_HEADLINE_BACKGROUND = 8;
    public static final int			COLOR_LIST_BACKGROUND_NORMAL =9;
    public static final int			COLOR_LIST_BACKGROUND_SELECTED =10;
    public static final int			COLOR_LIST_FOREGROUND_NORMAL =11;
    public static final int			COLOR_LIST_FOREGROUND_SELECTED =12;
    public static final int			COLOR_VERWEIS_VERWEIS=13;
    public static final int			COLOR_VERWEIS_TEXT=14;
    public static final int			COLOR_RECHNEN_STERN=15;
    public static final int			COLOR_LIST_BACKGROUND_ODD =16;
    public static final int			COLOR_LIST_BACKGROUND_EVEN =17;
    public static final int			COLOR_BESTAND_WASSER =18;
    public static final int			COLOR_RED=19;
    public static final int			COLOR_GREEN=20;
    public static final int			COLOR_LIST_EMPTY =21;
    public static final int			COLOR_LIST_INVENTUR_LITER =22;
    public static final int			COLOR_LIST_INVENTUR_GEWICHT =23;
    public static final int			COLOR_LIST_INVENTUR_LEER =24;
    public static final int			COLOR_STATISTIK_REZEPTUR_ALTERNATE =25;
    public static final int			COLOR_LIST_BACKGROUND_GELB =26;
    public static final int			COLOR_VISIBLE_GRID	= 27;
    public static final int			COLOR_WHITE=28;		
    public static final String		COLOR_MHD_WARNUNG="ffaa00";
    
    public static final String		COLOR_BESTAND_GREEN="#228b22";
    public static final String		COLOR_BESTAND_RED="#ff0000";
    public static final String		COLOR_BESTAND_YELLOW="#ffff00";
    public static final String		COLOR_BESTAND_GRAY="#bbbbbb";
    public static final int   		COLOR_BESTAND_YELLOW_VALUE=40;
    public static final int   		COLOR_BESTAND_RED_VALUE=10;
    public static final int			AUSWAHL_BESTAND_EINHEIT=500;
    public static final int			AUSWAHL_BESTAND_FILLWIDTH=20;
    public static final String		AUSWAHL_BESTAND_FILLCHAR="&nbsp;";
    
    public static final String		COLOR_TANKLAGERPANEL_FASTLEER="ff0000";
    
    //einstellungen
    public static final int		EINSTELLUNGEN_PROBE_ERFORDERLICH = 0;
    
    //pfade
    public static final String      LIST_ABFRAGE_ICON_CLASSPATH = "/de/lunqual/rzpro/gfx/abfrage_list_render_icon.png";
    public static final String      LIST_ABFRAGE_ICON_PRIVAT_CLASSPATH = "/de/lunqual/rzpro/gfx/abfrage_list_render_icon_privat.png";
    public static final String      LIST_ERGEBNIS_ICON_NOTIZ_CLASSPATH = "/de/lunqual/rzpro/gfx/ergebnis_list_render_icon_notiz.png";
    public static final String      LIST_ERGEBNIS_ICON_REZEPTUR_CLASSPATH = "/de/lunqual/rzpro/gfx/ergebnis_list_render_icon_rezeptur.png";
    public static final String      LIST_ERGEBNIS_ICON_REZEPTUR_SPEZIFIKATION_CLASSPATH = "/de/lunqual/rzpro/gfx/ergebnis_list_render_icon_rezeptur_spezifikation.png";
    public static final String      LIST_ERGEBNIS_ICON_AUSSTATTUNG_CLASSPATH = "/de/lunqual/rzpro/gfx/ergebnis_list_render_icon_ausstattung.png";
    public static final String      LIST_ERGEBNIS_ICON_VERWEIS_CLASSPATH = "/de/lunqual/rzpro/gfx/ergebnis_list_render_icon_verweis.png";
    public static final String      LIST_CONTAINER_SELECTED_CLASSPATH = "/de/lunqual/rzpro/gfx/container.list_selected.png";
    public static final String      LIST_CONTAINER_UNSELECTED_CLASSPATH = "/de/lunqual/rzpro/gfx/container.list_unselected.png";
    public static final String      LIST_CONTAINER_FASS_CLASSPATH = "/de/lunqual/rzpro/gfx/container.fass.png";


    //Kalkulation
    public static final int			OPTION_KALKULATION_DEFAULT_CURRENCY			= 1;

    public static final double	OPTION_KALKULATION_WASSERPREIS_MENGE		= 0.0;
    public static final int			OPTION_KALKULATION_WASSERPREIS_EINHEIT		= 1;
    public static final double	OPTION_KALKULATION_WASSERPREIS_PREIS			= 0.0;
    public static final int			OPTION_KALKULATION_WASSERPREIS_WAEHRUNG	= 1;

    public static final double	OPTION_KALKULATION_STEUER_MENGE					= 0.0;
    public static final int			OPTION_KALKULATION_STEUER_EINHEIT					= 1;
    public static final double	OPTION_KALKULATION_STEUER_PREIS					= 0.0;
    public static final int			OPTION_KALKULATION_STEUER_WAEHRUNG			= 1;


    //Herstellbuch
    public static final String		OPTION_HERSTELLBUCH_COLOR_ZUGANG				= "000000";
    public static final String		OPTION_HERSTELLBUCH_COLOR_ABGANG				= "ff0000";
    public static final String		OPTION_HERSTELLBUCH_COLOR_LOSNUMMER			= "0000ff";
    public static final String		OPTION_HERSTELLBUCH_COLOR_HERSTELLUNG		= "00ccff";
    public static final String		OPTION_HERSTELLBUCH_COLOR_HERSTELLUNG_TEXT		= "000000";
    public static final String		OPTION_HERSTELLBUCH_COLOR_SCHWUND			= "66ffff";
    public static final String		OPTION_HERSTELLBUCH_COLOR_SCHWUND_TEXT	= "000000";
    public static final String		OPTION_HERSTELLBUCH_COLOR_ENDMENGE			= "ccffff";
    public static final String		OPTION_HERSTELLBUCH_COLOR_ENDMENGE_TEXT	= "000000";

    public static final String		OPTION_AUSWAHL_COLOR_TEXT							="000000";
    public static final String		OPTION_AUSWAHL_COLOR_BACKGROUND				="ffffff";
    public static final String		OPTION_AUSWAHL_COLOR_HEADLINE_BACKGROUND				= "0000cc";
    public static final String		OPTION_AUSWAHL_COLOR_HEADLINE_TEXT							= "ffffff";
    public static final String		OPTION_AUSWAHL_COLOR_MARKUP						= "0000ff";
    public static final String		OPTION_AUSWAHL_COLOR_MARKUP_GREEN			= "00ff00";
    public static final String		OPTION_AUSWAHL_COLOR_ERSTELLT_TEXT				= "000000";
    public static final String		OPTION_AUSWAHL_COLOR_ERSTELLT_BACK			= "00ccff";
    public static final String		OPTION_AUSWAHL_COLOR_GEAENDERT_TEXT			= "000000";
    public static final String		OPTION_AUSWAHL_COLOR_GEAENDERT_BACK		= "66ffff";
    public static final String		OPTION_AUSWAHL_COLOR_ADRESSEN_TEXT			= "000000";
    public static final String		OPTION_AUSWAHL_COLOR_ADRESSEN_BACK 			= "ccffff";
    public static final String		OPTION_AUSWAHL_COLOR_STICHWORTE_TEXT		= "ffffff";
    public static final String		OPTION_AUSWAHL_COLOR_STICHWORTE_BACK		= "9900cc";
    public static final String		OPTION_AUSWAHL_COLOR_HINWEIS_TEXT		= "000000";
    public static final String		OPTION_AUSWAHL_COLOR_HINWEIS_BACK		= "ffff00";
    public static final String		OPTION_AUSWAHL_COLOR_YELLOW_BACK = "000000";
    public static final String		OPTION_AUSWAHL_COLOR_YELLOW_TEXT  = "ffffff";
    
    public static final String		OPTION_COLOR_GENUINE_RED ="ff0000";
    // Design

    public static final String			DESIGN_DEFAULT = "Nimbus";

    //mischungen
    public static final String		OPTION_COLOR_MISCHUNG_BUTTON_OK="ccccff";
    
    //Bestätigungsmeldungen
    public static final int             CONFIRM_ABGANG                                              = 1;
    public static final int             CONFIRM_ZUGANG                                              = 0;
    public static final int             CONFIRM_BUCHUNG                                            = 0;

    //Losnummer-Template
    public static final String		   DEFAULT_LOSNUMMER_TEMPLATE							= "L$m$y$n";
    public static final String		   DEFAULT_LOSNUMMER_VORSCHLAG_TEMPLATE		= "L$d$m$y$h$M.$b";
    public static final String		   DEFAULT_MUSTER_VORSCHLAG_TEMPLATE		=  "Muster M$d$m$y-$X ";
    // Invalid Chars, die nicht in Losnummern vorkommen dürfen !
    // das ist alles, was als Regular Expression aufgefasst werden kann
    public  static final String		  INVALID_CHARS													= "\\$^()[]{}*?~|#<>!\"";

    public static final String          SPONSOR_SPLASH                                              = "splash.png";
    public static final String          SPONSOR_INFO                                                  = "info.png";
    public static final String          SPONSOR_BUTTON                                             = "Besuchen Sie unseren Sponsor auf http://www.christiancarl.de";
    public static final String          SPONSOR_LINK                                                  = "http://www.christiancarl.de";
    public static final String          SPONSOR_BROWSER                                          = "mozilla";

    //Druckformulare im auswahlfenster
    public static final int				AUSWAHL_FORMULAR_REZEPTUR						= 9;
    public static final int				AUSWAHL_FORMULAR_KALKULATION					= 6;
    public static final int				AUSWAHL_FORMULAR_SPEZIFIKATION				= 27;
    public static final int				AUSWAHL_FORMULAR_DECKBLATT_SPEZIFIKATION				= -1;

    //Brennwert

    public static final int				BRENNWERT_ALKOHOL_KJ			= 29;
    public static final int				BRENNWERT_ALKOHOL_KK			= 7;
    public static final double		BRENNWERT_ALKOHOL_BE			= 0.1458;

    public static final int				BRENNWERT_EXTRAKT_KJ			= 17;
    public static final int				BRENNWERT_EXTRAKT_KK			= 4;
    public static final double		BRENNWERT_EXTRAKT_BE			= 0.08332;


    private static final double		BRENNWERT_KJ_TO_KCAL = 0.2388915;
    private static final double  	BRENNWERT_KJ_TO_BE= 0.0050276;
    //Statistik-grafik
    public static final int				ST_GRAFIK_HERSTELLUNG_SELECTED = 0;
    public static final int				ST_GRAFIK_STATISTIK_SELECTED = 0;
    
    public static final String		FUELLGEWICHT_LISTE = "0.1;0.2;0.35;0.5;0.7;0.75;1;2;3;5;10;20;25";

    
    public static final String DBBUCHUNG_TANK_REGEX	=	"\\[Tank.*\\]";
    public static final String DBBUCHUNG_TANK_SB			=	"[Tank";
    public static final String DBBUCHUNG_TANK_SE			= "]";
    public static final String DBBUCHUNG_TICKETS_REGEX	=	"\\[Tickets.*\\]";
    public static final String DBBUCHUNG_TICKETS_SB			=	"[Tickets";
    public static final String DBBUCHUNG_TICKETS_SE			= "]";                           
    
    public static final int	LIEFERSCHEIN_ABFUELLTAG = 0;
    public static final int	LIEFERSCHEINLISTE_ABFUELLTAG = 0;
    public static final String	LIEFERSCHEINLISTE_L_MUSTER = "L";
        
    
    public static final int	REZEPTUR_TEMPERATUR_DEFAULT=20;
    public static final int	REZEPTUR_TEMPERATUR_MIN=-20;
    public static final int	REZEPTUR_TEMPERATUR_MAX=30;
    
    public static final int	RECHNEN_LAYOUT=1;
    
    
    public static final int MISCHUNGSLISTENFENSTER_ABFRAGE_ANZAHL = 20;
    
    public static final int  		INVENTUREINGABE_PREFIX = 1;
    

    public static final int	BARCODE_WIDTH = 800;
    public static final int	BARCODE_OFFSET = 30;
    
    public static final double DEFAULT_TRACE_LIMIT = 2.0;
    
    public static final int DEFAULT_TANKLAGER_LAYOUT = 0;
    
    public static final int DEFAULT_TANKLAGER_ZOOM = 100;
    
    public static final int VERLAUF_RANGE_MAX = 1000;
    
    
    public static final String			DATENBLATT_DEFAULT = "$l\n$f1.Chemische Charakterisierung\n$l\n" +
       "1.1 Äthanol-Wasser-Gemisch in obengenannter Volumenkonzentration\n" +
       "1.2 Form: Flüssig\n"+
       "1.3 Farbe:\n"+
       "1.4 Geruch: Typisch\n\n" +
       "$l\n$f2. Physikalische und sicherheitstechnische Daten\n$l\n"+
       "2.1 Siedepunkt: Über 78,4°C\n"+
       "2.2 Mischbarkeit mit Wasser: in jedem beliebigen Verhältnis\n" +
       "2.3 PH-Wert:Leicht sauer\n"+
       "2.4 Flammpunkt:über 23°C\n\n"+
       "$l\n$f3. Transport\n$l\n"+
       "UN-Nr. 3065\n"+
       "Gefahrgutklasse 3 VP III\n"+
       "$fAlkoholische Getränke bis 70 % Vol in Verpackungen bis 250 Liter\n"+
       "$funterliegen nicht der Gefahrgutverordnung\n\n"+
       "$l\n$f4. Vorschriften\n$l\n"+
       "Gefahrstoff-Verordnung:\n"+
       "     R-Satz 10: Entzündlich\n"+
       "     R-Satz 7:  Behälter dicht geschlossen halten\n"+
       "     R-Satz 16: von Zündquellen fernhalten, nicht rauchen\n\n"+
       "$l\n$f5.Schutzmaßnahmen, Lagerung und Handhabung\n$l\n"+
       "5.1 technische Schutzmaßnahmen: Behälter kühl lagern, von Zündquellen fernhalten\n"+
       "5.2 Persönliche Schutzausrüstung: Nicht erforderlich\n"+
       "5.3 Brand- und Explosionsschutz: Nicht rauchen, von Zündquellen fernhalten\n\n"+
       "$l\n$f6.Maßnahmen bei Unfällen und Bränden\n$l\n"+
       "6.1 Nach Verschütten oder Auslaufen:\n"+
       "          Mechanisch oder mit flüssigkeitsbindendem Material aufnehmen\n"+
       "6.2 Geeignete Löschmittel:\n"+
       "          Wassersprühstrahl, Löschpulver, CO2, alkoholbeständiger Schaum\n"+
       "6.3 Erste Hilfe:\n"+
       "         Nach Augenkontakt mit Wasser ausspülen\n\n"+
       "$l\n$f7.Angaben zur Ökologie\n$l\n"+
       "7.1 Biologisch abbaubar\n\n"+
       "$l\n$fSonstige Bemerkungen\n$l\n"+
       "\n\n"+
       "$l\nDieses Dokument ist maschinell erstellt und ohne Unterschrift gültig\n";

    public static final int TANKLISTE_BELEGUNG_LAST_COUNT		= 5;
    
    public static final String LIEFERSCHEIN_EAN_DEFAULT_PREFIX = "Lose Ware";
    public static final String ETIKETTEN_EAN_DEFAULT_PREFIX = "Lose Ware";
    
    
    public static final int TANKLAGERPANEL_BEMERKUNGEN_FONTSIZE = 9;
    
    
    public static final int MAIN_RESOLUTION_MIN_LAYOUT_SWITCH=1500;
    
    public static final int MISCHUNG_CHART_MAX_COLORS = 16;
    
    public static final int  MISCHUNG_CHART_MAX_LIST = 16;
    public static final int  MISCHUNG_CHART_LIST = 8;
    
    public static final String CHART_COLOR_0="ffa700";
    public static final String CHART_COLOR_1="00ff00";
    public static final String CHART_COLOR_2="0000ff";
    public static final String CHART_COLOR_3="ffff00";
    
    public static final String CHART_COLOR_4="ff00ff";
    public static final String CHART_COLOR_5="00ffff";
    public static final String CHART_COLOR_6="8b0000";
    public static final String CHART_COLOR_7="006400";
    
    public static final String CHART_COLOR_8="00008b";
    public static final String CHART_COLOR_9="ff0000";
    public static final String CHART_COLOR_10="ff7f50";
    public static final String CHART_COLOR_11="adff2f";
    
    public static final String CHART_COLOR_12="00bfff";
    public static final String CHART_COLOR_13="ffdab9";
    public static final String CHART_COLOR_14="e0ffff";
    public static final String CHART_COLOR_15="aaaaaa";
    
    public static final String CHANGES_MARKUP_BACKGROUND ="00ff00";
    public static final String CHANGES_MARKUP_TEXT ="000000";
    public static final String CHANGES_MARKUP_OLD_BACKGROUND="ff0000";
    public static final String CHANGES_MARKUP_OLD_TEXT="ffffff";
    
    
    public static final String  DATEPICKER_FORMAT = "EEEE dd. MMMM yyyy";
    
    public static final int		DOKUMENTPANEL_MIN_SCALE = 20;
    public static final int		DOKUMENTPANEL_MAX_SCALE = 400;
    
    public static final int		TANKLAGER_PREFERRED_WIDTH=2000;
    public static final int		TANKLAGER_PREFERRED_HEIGHT=2000;
    public static final int		TANKLAGER_MODE_FIX=0;
    public static final int 	TANKLAGER_MIN_SIZE=600;
    public static final int		TANKLAGER_MAX_SIZE=5000;
    
    
    public static final int    	LAST_ORDERS_COUNT = 3;
    public static final int    	LABORWERTE_DECIMAL_DIGITS= 6;
    
    public static final String CSV_CHARACTER = ",";

    RzPro               	rz;
    String              	OptionsFileName;
    SortedProperties   	 	options;

    Icon                	abfrageListIcon;
    Icon					abfrageListPrivatIcon;
    Icon                	ergebnisListNotizIcon;
    Icon                	ergebnisListRezepturIcon;
    Icon				  	ergebnisListVerweisIcon;
    Icon				  	ergebnisListAusstattungIcon;
    Icon					containerSelected;
    Icon					containerUnselected;
    Icon					containerFass;

    Color					selectionForeground;
    Color					selectionBackground;
    Color					textHighlightForeground;
    Color					textHighlightBackground;
    Color					textHeadlineBackground;
    Color					bestandGruen;
    Color					bestandGelb;
    Color					bestandRot;
    Color					bestandWhite;
    Color					bestandWasser;
    Color					listForegroundNormal;
    Color					listForegroundSelected;
    Color					listBackgroundNormal;
    Color					listBackgroundSelected;
    Color					listEmpty;
    Color					verweisVerweis;
    Color					verweisText;
    Color					rechnenStern;
    Color					listOdd;
    Color					listEven;
    Color 					red;
    Color					green;
    Color 					inventurLiter;
    Color					inventurGewicht;
    Color 					inventurLeer;
    Color					statistikRezepturAlternate;
    Color					listBackgroundGelb;
    Color					visibleGridColor;
    Color					white;
    Color					mhdWarnung;
    
    String					url1;
    //plugin
    String				pluginPath;
    /**
     * Creates a new instance of OptionControl
     * @param r übergebene RzPro-Struktur
     */
    public OptionFactory(RzPro r) {
        rz = r;
        pluginPath = System.getProperty("java.home") + System.getProperty("file.separator") + "lib" + System.getProperty("file.separator") + "ext" + System.getProperty("file.separator");
        options = new SortedProperties();
        readOptions();
    }

    
    /**
     * liest die Optionen aus der Datei ein
     * und richtet  noch ein paar Standard-Voreinstellungen
     * ein
     */
    public void readOptions(){
        boolean noFile = false;
        setOption("optioncontrol.folder",OPTION_FOLDER);
        setOption("optioncontrol.filename",OPTION_FILE);
        // erst mal nachsehen, ob der Ordner für die Einstellungen überhaupt existiert,
        // und bei Bedarf anlegen
       final String optionFolder = getUserHomeDirectory()+ System.getProperty("file.separator")+ OPTION_FOLDER;
        if (! new File(optionFolder).exists()) {
       		new File(optionFolder).mkdir();
        }
        // Optionen laden
        // default optionsdatei
        OptionsFileName = getPropertyFolder() + System.getProperty("file.separator") + OPTION_FILE;
        	if(rz.getDatabase() != null && rz.getDatabase().dbGetUser() != null && !rz.getDatabase().dbGetUser().equals("")) {
        	// Database ist initialisiert und ein User angemeldet. In diesem Falle laden wir eine userbezogene Optionsdatei
        		if(rz.getDatabase().getOptionen().userExists(rz.getDatabase().dbGetUser())) {
        			url1=getOption("database.url");
        			options = null;
        			options = rz.getDatabase().getOptionen().getOptionen(DBOptionen.OPTION_TYP_OPTION);
        			if(url1 != null && !url1.equals("")){
        				setOption("database.url",url1);
        			}
        		}
        	} else {
                try {
                    final FileInputStream input = new FileInputStream(OptionsFileName);
                    options.clear();
                    options.load(input);
                    input.close();
                   	url1=getOption("database.url");
               }
                catch (final IOException e ){
                    rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "OptionControl.readOptions:" ,  e.getLocalizedMessage());
                    noFile = true;
               }
        	}
        	
        	//Default inactivity timeout
        	
            if(getOption("default.inactivity.timeout").equals("")) {
       			setOption("default.inactivity.timeout",DEFAULT_INACTIVITY_TIMEOUT);
       		}
        	
         if(getOption("rechnen.layout").equals("")) {
    			setOption("rechnen.layout",RECHNEN_LAYOUT);
    		}
        if(getOption("localecontrol.path").equals("")) {
			setOption("localecontrol.path",LocaleFactory.LOCALE_PATH);
		}
        if(getOption("localecontrol.file").equals("")) {
			setOption("localecontrol.file",LocaleFactory.LOCALE_FILE);
		}
        if(getOption("fenstercontrol.filename").equals("")) {
			setOption("fenstercontrol.filename",LocaleFactory.FENSTER_FILE);
		}
        if(getOption("fontcontrol.filename").equals("")) {
			setOption("fontcontrol.filename",FontFactory.FONT_FILE);
		}
        if(getOption("database.url").equals("")) {
			setOption("database.url",DBFactory.DefaultDataBaseURL);
		}
        if(getOption("list.timeout").equals("")) {
			setOption("list.timeout",RzPro.LIST_TIMEOUT);
		}
        if(getOption("auswahl.abfrageliste_max").equals("")) {
			setOption("auswahl.abfrageliste_max",AUSWAHL_ABFRAGELISTE_MAX );
		}

        if(getOption("system.gc_on_login").equals("")) {
			setOption("system.gc_on_login",RzPro.DEFAULT_GC_HANDLING);
		}
        if(getOption("bestandswarnung.timer").equals("")) {
			setOption("bestandswarnung.timer",BESTANDSWARNUNGS_INTERVAL);
		}
        if(getOption("auftragsliste.timer").equals("")) {
			setOption("auftragsliste.timer",AUFTRAGSLISTE_INTERVAL);
		}
        if(getOption("anfragenliste.timer").equals("")) {
			setOption("anfragenliste.timer",ANFRAGENLISTE_INTERVAL);
		}
        if(getOption("client_auftragsliste.timer").equals("")) {
			setOption("client_auftragsliste.timer",AUFTRAGSLISTE_INTERVAL);
		}
        if(getOption("client_anfragenliste.timer").equals("")) {
			setOption("client_anfragenliste.timer",ANFRAGENLISTE_INTERVAL);
		}
        if(getOption("bestandswarnung.zutaten").equals("")) {
			setOption("bestandswarnung.zutaten",BESTANDSWARNUNGS_ZUTATEN);
		}
        if(getOption("bestandswarnung.buchungen").equals("")) {
			setOption("bestandswarnung.buchungen",BESTANDSWARNUNGS_BUCHUNGEN);
		}
        if(getOption("bestandswarnung.status_0").equals("")) {
			setOption("bestandswarnung.status_0",BESTANDSWARNUNG_STATUS_0);
		}
        if(getOption("bestandswarnung.status_1").equals("")) {
			setOption("bestandswarnung.status_1",BESTANDSWARNUNG_STATUS_1);
		}
        if(getOption("bestandswarnung.status_2").equals("")) {
			setOption("bestandswarnung.status_2",BESTANDSWARNUNG_STATUS_2);
		}
        if(getOption("bestandswarnung.status_color_0").equals("")) {
			setOption("bestandswarnung.status_color_0",BESTANDSWARNUNG_STATUS_COLOR_0);
		}
        if(getOption("bestandswarnung.status_color_1").equals("")) {
			setOption("bestandswarnung.status_color_1",BESTANDSWARNUNG_STATUS_COLOR_1);
		}
        if(getOption("bestandswarnung.status_color_2").equals("")) {
			setOption("bestandswarnung.status_color_2",BESTANDSWARNUNG_STATUS_COLOR_2);
		}
        if(getOption("bestandswarnung.status_color_3").equals("")) {
			setOption("bestandswarnung.status_color_3",BESTANDSWARNUNG_STATUS_COLOR_3);
		}

        if(getOption("report.basedir").equals("")) {
			setOption("report.basedir",ReportFactory.REPORT_FOLDER);
		}
        if(getOption("report.adresse").equals("")) {
			setOption("report.adresse",ReportFactory.REPORT_DEFAULT_ADRESSE);
		}
        if(getOption("report.notiz").equals("")) {
			setOption("report.notiz",ReportFactory.REPORT_DEFAULT_NOTIZ);
		}
        if(getOption("report.rezeptur").equals("")) {
			setOption("report.rezeptur",ReportFactory.REPORT_DEFAULT_REZEPTUR);
		}
        if(getOption("report.rechnen").equals("")) {
			setOption("report.rechnen",ReportFactory.REPORT_DEFAULT_RECHNEN);
		}
        if(getOption("report.staerke").equals("")) {
			setOption("report.staerke",ReportFactory.REPORT_DEFAULT_RECHNEN);
		}
        if(getOption("report.containerliste").equals("")) {
			setOption("report.containerliste",ReportFactory.REPORT_DEFAULT_CONTAINERLISTE);
		}
        if(getOption("report.lieferschein").equals("")) {
			setOption("report.lieferschein",ReportFactory.REPORT_DEFAULT_LIEFERSCHEIN);
		}
        if(getOption("report.etiketten").equals("")) {
			setOption("report.etiketten",ReportFactory.REPORT_DEFAULT_ETIKETTEN);
		}
        if(getOption("report.tafel").equals("")) {
			setOption("report.tafel",ReportFactory.REPORT_DEFAULT_TAFEL);
		}
        if(getOption("report.statistik").equals("")) {
			setOption("report.statistik",ReportFactory.REPORT_DEFAULT_STATISTIK);
		}
        if(getOption("report.herstellung").equals("")) {
			setOption("report.herstellung",ReportFactory.REPORT_DEFAULT_HERSTELLUNG);
		}
        if(getOption("report.lagerliste").equals("")) {
			setOption("report.lagerliste",ReportFactory.REPORT_DEFAULT_LAGERLISTE);
		}
        if(getOption("report.lagerbestand").equals("")) {
			setOption("report.lagerbestand",ReportFactory.REPORT_DEFAULT_LAGERBESTAND);
		}
        if(getOption("report.verlauf").equals("")) {
			setOption("report.verlauf",ReportFactory.REPORT_DEFAULT_VERLAUF);
		}
        
        //report
        if(getOption("report.general.pageformat").equals("")) {
			setOption("report.general.pageformat",ReportFactory.REPORT_DEFAULT_PAGEFORMAT);
		}
        if(getOption("report.general.margin.top").equals("")) {
			setOption("report.general.margin.top",ReportFactory.REPORT_DEFAULT_MARGIN_TOP);
		}
        if(getOption("report.general.margin.bottom").equals("")) {
			setOption("report.general.margin.bottom",ReportFactory.REPORT_DEFAULT_MARGIN_BOTTOM);
		}
        if(getOption("report.general.margin.left").equals("")) {
			setOption("report.general.margin.left",ReportFactory.REPORT_DEFAULT_MARGIN_LEFT);
		}
        if(getOption("report.general.margin.right").equals("")) {
			setOption("report.general.margin.right",ReportFactory.REPORT_DEFAULT_MARGIN_RIGHT);
		}

        if(getOption("report.landscape.margin.top").equals("")) {
			setOption("report.landscape.margin.top",ReportFactory.REPORT_DEFAULT_LANDSCAPE_MARGIN_TOP);
		}
        if(getOption("report.landscape.margin.bottom").equals("")) {
			setOption("report.landscape.margin.bottom",ReportFactory.REPORT_DEFAULT_LANDSCAPE_MARGIN_BOTTOM);
		}
        if(getOption("report.landscape.margin.left").equals("")) {
			setOption("report.landscape.margin.left",ReportFactory.REPORT_DEFAULT_LANDSCAPE_MARGIN_LEFT);
		}
        if(getOption("report.landscape.margin.right").equals("")) {
			setOption("report.landscape.margin.right",ReportFactory.REPORT_DEFAULT_LANDSCAPE_MARGIN_RIGHT);
		}

        if(getOption("report.general.pageheader.background").equals("")) {
			setOption("report.general.pageheader.background",ReportFactory.REPORT_DEFAULT_PAGEHEADER_BACKGROUND);
		}
        if(getOption("report.general.pagefooter.background").equals("")) {
			setOption("report.general.pagefooter.background",ReportFactory.REPORT_DEFAULT_PAGEFOOTER_BACKGROUND);
		}
        if(getOption("report.general.reportheader.background").equals("")) {
			setOption("report.general.reportheader.background",ReportFactory.REPORT_DEFAULT_REPORTHEADER_BACKGROUND);
		}
        if(getOption("report.general.reportfooter.background").equals("")) {
			setOption("report.general.reportfooter.background",ReportFactory.REPORT_DEFAULT_REPORTFOOTER_BACKGROUND);
		}
        if(getOption("report.general.highlight.background").equals("")) {
			setOption("report.general.highlight.background",ReportFactory.REPORT_DEFAULT_HIGHLIGHT_BACKGROUND);
		}
        if(getOption("report.statistik.highlight.abgang").equals("")) {
			setOption("report.statistik.highlight.abgang",ReportFactory.REPORT_DEFAULT_HIGHLIGHT_STATISTIK_ABGANG);
		}
        if(getOption("report.statistik.color.abgang").equals("")) {
			setOption("report.statistik.color.abgang",ReportFactory.REPORT_DEFAULT_COLOR_STATISTIK_ABGANG);
		}
        if(getOption("report.statistik.color.zugang").equals("")) {
			setOption("report.statistik.color.zugang",ReportFactory.REPORT_DEFAULT_COLOR_STATISTIK_ZUGANG);
		}
        if(getOption("report.etiketten.fontsize").equals("")) {
			setOption("report.etiketten_fontsize",ReportFactory.REPORT_DEFAULT_ETIKETTEN_FONTSIZE);
		}

        //losnummer-template
        if(getOption( "losnummer.vtemplate").equals("")) {
			setOption( "losnummer.vtemplate",DEFAULT_LOSNUMMER_VORSCHLAG_TEMPLATE);
		}

        //zutatendialog
        if(!options.containsKey("zutatendialog.prefix")) {
			setOption("zutatendialog.prefix",ZutatenDialog.DEFAULT_PREFIX_OFF);
		}
        if(getOption("zutatendialog.limit").equals("")) {
			setOption("zutatendialog.limit",ZutatenDialog.DEFAULT_LIMIT);
		}


        // einzelne Berichte
        
		setOption("report.konform.orientation",KonformDrucken.DEFAULT_ORIENTATION);
        
        if(getOption("report.mischung.orientation").equals("")) {
			setOption("report.mischung.orientation",MischungDrucken.DEFAULT_ORIENTATION);
		}
        if(getOption("report.mischungsliste.orientation").equals("")) {
			setOption("report.mischungliste.orientation",MischungslisteDrucken.DEFAULT_ORIENTATION);
		}
        if(getOption("report.auftragsliste.orientation").equals("")) {
			setOption("report.auftragsliste.orientation",AuftragslisteDrucken.DEFAULT_ORIENTATION);
		}
        if(getOption("report.rechnen.orientation").equals("")) {
			setOption("report.rechnen.orientation",RechenBlattDrucken.DEFAULT_ORIENTATION);
		}
        if(getOption("report.rezeptur.orientation").equals("")) {
			setOption("report.rezeptur.orientation",RezepturAusgabeDrucken.DEFAULT_ORIENTATION);
		}
        if(getOption("report.notiz.orientation").equals("")) {
			setOption("report.notiz.orientation",NotizAusgabeDrucken.DEFAULT_ORIENTATION);
		}
        if(getOption("report.ergebnisliste.orientation").equals("")) {
			setOption("report.ergebnisliste.orientation",ErgebnislisteAusgabeDrucken.DEFAULT_ORIENTATION);
		}
        if(getOption("report.adresse.orientation").equals("")) {
			setOption("report.adresse.orientation",AdressenAusgabeDrucken.DEFAULT_ORIENTATION);
		}
        if(getOption("report.lieferschein.orientation").equals("")) {
			setOption("report.lieferschein.orientation",AdressenAusgabeDrucken.DEFAULT_ORIENTATION);
		}
        if(getOption("report.statistik.orientation").equals("")) {
			setOption("report.statistik.orientation",StatistikDrucken.DEFAULT_STATISTIK_ORIENTATION);
		}
        if(getOption("report.herstellung.orientation").equals("")) {
			setOption("report.herstellung.orientation",HerstellungDrucken.DEFAULT_HERSTELLUNG_ORIENTATION);
		}
        if(getOption("report.lagerliste.orientation").equals("")) {
			setOption("report.lagerliste.orientation",LagerListeDrucken.DEFAULT_LAGERLISTE_ORIENTATION);
		}
        if(getOption("report.lagerbestand.orientation").equals("")) {
			setOption("report.lagerbestand.orientation",LagerBestandDrucken.DEFAULT_ORIENTATION);
		}
        if(getOption("report.verlauf.orientation").equals("")) {
			setOption("report.verlauf.orientation",VerlaufDrucken.DEFAULT_ORIENTATION);
		}
        if(getOption("report.inventur.orientation").equals("")) {
			setOption("report.inventur.orientation",InventurDrucken.DEFAULT_INVENTUR_ORIENTATION);
		}
        if(getOption("report.ausstattung.orientation").equals("")) {
			setOption("report.ausstattung.orientation",AusstattungRawDrucken.DEFAULT_ORIENTATION);
		}
        if(getOption("report.ausstattung_calc.orientation").equals("")) {
			setOption("report.ausstattung.calc_orientation",AusstattungCalcDrucken.DEFAULT_ORIENTATION);
		}
        if(getOption("report.changes.orientation").equals("")) {
			setOption("report.changes.orientation",ChangesDrucken.DEFAULT_ORIENTATION);
		}
        
        if(getOption("report.laborwerte.orientation").equals("")) {
			setOption("report.laborwerte.orientation",LaborwertDrucken.DEFAULT_ORIENTATION);
		}

        if(getOption("report.ergebnislistebestand.orientation").equals("")) {
			setOption("report.ergebnislistebestand.orientation",ErgebnislisteBestandDrucken.DEFAULT_ORIENTATION);
        }

        if(getOption("report.bestellungsliste.orientation").equals("")) {
			setOption("report.bestellungsliste.orientation",BestellungslisteDrucken.DEFAULT_ORIENTATION);
        }
        
        if(getOption("report.temperaturzonen.orientation").equals("")) {
			setOption("report.temperaturzonen.orientation",TemperaturzonenDrucken.DEFAULT_ORIENTATION);
        }
        if(getOption("report.bewertung.orientation").equals("")) {
			setOption("report.bewertung.orientation",BewertungDrucken.DEFAULT_ORIENTATION);
		}
        
        if(getOption("report.zutatenliste.orientation").equals("")) {
			setOption("report.zutatenliste.orientation",ZutatenlisteDrucken.DEFAULT_ORIENTATION);
		}
        
        if(!options.contains("report.trace.orientation")) {
			setOption("report.trace.orientation",TraceDrucken.DEFAULT_ORIENTATION);
		}
        
        if(!options.contains("trace.recursion.max")) {
			setOption("trace.recursion.max",TraceItem.TRACE_RECURSION_MAX);
		}
        
        if(getOption("printercommand").equals("")) {
			setOption("printercommand",ReportFactory.REPORT_PRINTERCOMMAND);
		}
        // Kalkulation
        if(getOption("kalkulation.currency").equals("")) {
			setOption("kalkulation.currency",OPTION_KALKULATION_DEFAULT_CURRENCY);
		}
        if(getOption("kalkulation.wasserpreis_menge").equals("")) {
			setDouble("kalkulation.wasserpreis_menge",OPTION_KALKULATION_WASSERPREIS_MENGE);
		}
        if(getOption("kalkulation.wasserpreis_einheit").equals("")) {
			setOption("kalkulation.wasserpreis_einheit",OPTION_KALKULATION_WASSERPREIS_EINHEIT);
		}
        if(getOption("kalkulation.wasserpreis_preis").equals("")) {
			setDouble("kalkulation.wasserpreis_preis",OPTION_KALKULATION_WASSERPREIS_PREIS);
		}
        if(getOption("kalkulation.wasserpreis_waehrung").equals("")) {
			setOption("kalkulation.wasserpreis_waehrung",OPTION_KALKULATION_WASSERPREIS_WAEHRUNG);
		}
        if(getOption("kalkulation.steuer_menge").equals("")) {
			setDouble("kalkulation.steuer_menge",OPTION_KALKULATION_STEUER_MENGE);
		}
        if(getOption("kalkulation.steuer_einheit").equals("")) {
			setOption("kalkulation.steuer_einheit",OPTION_KALKULATION_STEUER_EINHEIT);
		}
        if(getOption("kalkulation.steuer_preis").equals("")) {
			setDouble("kalkulation.steuer_preis",OPTION_KALKULATION_STEUER_PREIS);
		}
        if(getOption("kalkulation.steuer_waehrung").equals("")) {
			setOption("kalkulation.steuer_waehrung",OPTION_KALKULATION_STEUER_WAEHRUNG);
		}

        if(getOption("einstellungen.staerkeliste").equals("")) {
			setOption("einstellungen.staerkeliste","");
		}
        if(getOption("einstellungen.extraktliste").equals("")) {
			setOption("einstellungen.extraktliste","");
		}
        if(this.options.getProperty("einstellungen.probe_erforderlich") == null) {
        	setOption("einstellungen.probe_erforderlich",EINSTELLUNGEN_PROBE_ERFORDERLICH);
        }
        
        if(getOption("rezeptur.default_einheit").equals("")) {
			setOption("rezeptur.default_einheit",RzPro.OPTION_REZEPTUR_DEFAULT_EINHEIT);
		}

        if(getOption("abfrageliste.icon_classpath").equals("")) {
			setOption("abfrageliste.icon_classpath",LIST_ABFRAGE_ICON_CLASSPATH);
		}
        if(getOption("abfrageliste.icon_privat_classpath").equals("")) {
			setOption("abfrageliste.icon_privat_classpath",LIST_ABFRAGE_ICON_PRIVAT_CLASSPATH);
		}
        if(getOption("rergebnisliste.icon_notiz_classpath").equals("")) {
			setOption("ergebnisliste.icon_notiz_classpath",LIST_ERGEBNIS_ICON_NOTIZ_CLASSPATH);
		}
        if(getOption("ergebnisliste.icon_rezeptur_classpath").equals("")) {
			setOption("ergebnisliste.icon_rezeptur_classpath",LIST_ERGEBNIS_ICON_REZEPTUR_CLASSPATH);
		}
        if(getOption("ergebnisliste.icon_ausstattung_classpath").equals("")) {
			setOption("ergebnisliste.icon_ausstattung_classpath", LIST_ERGEBNIS_ICON_AUSSTATTUNG_CLASSPATH);
		}
        if(getOption("ergebnisliste.icon_verweis_classpath").equals("")) {
			setOption("ergebnisliste.icon_verweis_classpath",LIST_ERGEBNIS_ICON_VERWEIS_CLASSPATH);
		}
        if(getOption("container.ordner_selected_classpath").equals("")) {
			setOption("container.ordner_selected_classpath",LIST_CONTAINER_SELECTED_CLASSPATH);
		}
        if(getOption("container.ordner_unselected_classpath").equals("")) {
			setOption("container.ordner_unselected_classpath",LIST_CONTAINER_UNSELECTED_CLASSPATH);
		}
        if(getOption("container.fass_classpath").equals("")) {
			setOption("container.fass_classpath",LIST_CONTAINER_FASS_CLASSPATH);
		}


        // Zahlenformate

        if(getOption( "nff.normal_i_min").equals("")) {
			setOption( "nff.normal_i_min",NFF_NORMAL_I_MIN);
		}
        if(getOption( "nff.normal_i_max").equals("")) {
			setOption( "nff.normal_i_max",NFF_NORMAL_I_MAX);
		}
        if(getOption( "nff.normal_f_min").equals("")) {
			setOption( "nff.normal_f_min",NFF_NORMAL_F_MIN);
		}
        if(getOption( "nff.normal_f_max").equals("")) {
			setOption( "nff.normal_f_max",NFF_NORMAL_F_MAX);
		}

        if(getOption( "nff.litergewicht_i_min").equals("")) {
			setOption( "nff.litergewicht_i_min",NFF_LITERGEWICHT_I_MIN);
		}
        if(getOption( "nff.litergewicht_i_max").equals("")) {
			setOption( "nff.litergewicht_i_max",NFF_LITERGEWICHT_I_MAX);
		}
        if(getOption( "nff.litergewicht_f_min").equals("")) {
			setOption( "nff.litergewicht_f_min",NFF_LITERGEWICHT_F_MIN);
		}
        if(getOption( "nff.litergewicht_f_max").equals("")) {
			setOption( "nff.litergewicht_f_max",NFF_LITERGEWICHT_F_MAX);
		}

        if(getOption( "nff.staerke_i_min").equals("")) {
			setOption( "nff.staerke_i_min",NFF_STAERKE_I_MIN);
		}
        if(getOption( "nff.staerke_i_max").equals("")) {
			setOption( "nff.staerke_i_max",NFF_STAERKE_I_MAX);
		}
        if(getOption( "nff.staerke_f_min").equals("")) {
			setOption( "nff.staerke_f_min",NFF_STAERKE_F_MIN);
		}
        if(getOption( "nff.staerke_f_max").equals("")) {
			setOption( "nff.staerke_f_max",NFF_STAERKE_F_MAX);
		}

        if(getOption( "nff.exchange_i_min").equals("")) {
			setOption( "nff.exchange_i_min",NFF_EXCHANGE_I_MIN);
		}
        if(getOption( "nffexchange._i_max").equals("")) {
			setOption( "nff.exchange_i_max",NFF_EXCHANGE_I_MAX);
		}
        if(getOption( "nff.exchange_f_min").equals("")) {
			setOption( "nff.exchange_f_min",NFF_EXCHANGE_F_MIN);
		}
        if(getOption( "nff.exchange_f_max").equals("")) {
			setOption( "nff.exchange_f_max",NFF_EXCHANGE_F_MAX);
		}

        if(getOption( "nff.lieferschein_i_min").equals("")) {
			setOption( "nff.lieferschein_i_min",NFF_LIEFERSCHEIN_I_MIN);
		}
        if(getOption( "nff.lieferschein_i_max").equals("")) {
			setOption( "nff.lieferschein_i_max",NFF_LIEFERSCHEIN_I_MAX);
		}
        if(getOption( "nff.lieferschein_f_min").equals("")) {
			setOption( "nff.lieferschein_f_min",NFF_LIEFERSCHEIN_F_MIN);
		}
        if(getOption( "nff.lieferschein_f_max").equals("")) {
			setOption( "nff.lieferschein_f_max",NFF_LIEFERSCHEIN_F_MAX);
		}

        if(getOption( "nff.inventur_i_min").equals("")) {
			setOption( "nff.inventur_i_min",NFF_LIEFERSCHEIN_I_MIN);
		}
        if(getOption( "nff.inventur_i_max").equals("")) {
			setOption( "nff.inventur_i_max",NFF_LIEFERSCHEIN_I_MAX);
		}
        if(getOption( "nff.inventur_f_min").equals("")) {
			setOption( "nff.inventur_f_min",NFF_LIEFERSCHEIN_F_MIN);
		}
        if(getOption( "nff.inventur_f_max").equals("")) {
			setOption( "nff.inventur_f_max",NFF_INVENTUR_F_MAX);
		}

        if(getOption( "nff.one_i_min").equals("")) {
			setOption( "nff.one_i_min",1);
		}
        if(getOption( "nff.one_i_max").equals("")) {
			setOption( "nff.one_i_max",NFF_LIEFERSCHEIN_I_MAX);
		}
        if(getOption( "nff.one_f_min").equals("")) {
			setOption( "nff.one_f_min",0);
		}
        if(getOption( "nff.one_f_max").equals("")) {
			setOption( "nff.one_f_max",0);
		}


        // Double_Null
        if(getOption( "nff.null").equals("")) {
			setOption( "nff.null",RzPro.DOUBLE_NULL);
		}
        if(getOption( "buchung.precision").equals("")) {
			setOption( "buchung.precision",DBBuchung.BUCHUNG_PRECISION);
		}


        // Farben Herstellbuch
        if(getOption( "herstellbuch.color_zugang").equals("")) {
			setOption( "herstellbuch.color_zugang",OPTION_HERSTELLBUCH_COLOR_ZUGANG);
		}
        if(getOption( "herstellbuch.color_abgang").equals("")) {
			setOption( "herstellbuch.color_abgang",OPTION_HERSTELLBUCH_COLOR_ABGANG);
		}
        if(getOption( "herstellbuch.color_losnummer").equals("")) {
			setOption( "herstellbuch.color_losnummer",OPTION_HERSTELLBUCH_COLOR_LOSNUMMER);
		}
        if(getOption( "herstellbuch.color_herstellung_back").equals("")) {
			setOption( "herstellbuch.color_herstellung_back",OPTION_HERSTELLBUCH_COLOR_HERSTELLUNG);
		}
        if(getOption( "herstellbuch.color_endmenge_back").equals("")) {
			setOption( "herstellbuch.color_endmenge_back",OPTION_HERSTELLBUCH_COLOR_ENDMENGE);
		}
        if(getOption( "herstellbuch.color_schwund_back").equals("")) {
			setOption( "herstellbuch.color_schwund_back",OPTION_HERSTELLBUCH_COLOR_ENDMENGE);
		}
        if(getOption( "herstellbuch.color_herstellung_text").equals("")) {
			setOption( "herstellbuch.color_herstellung_text",OPTION_HERSTELLBUCH_COLOR_HERSTELLUNG_TEXT);
		}
        if(getOption( "herstellbuch.color_endmenge_text").equals("")) {
			setOption( "herstellbuch.color_endmenge_text",OPTION_HERSTELLBUCH_COLOR_ENDMENGE_TEXT);
		}
        if(getOption( "herstellbuch.color_schwund_text").equals("")) {
			setOption( "herstellbuch.color_schwund_text",OPTION_HERSTELLBUCH_COLOR_ENDMENGE_TEXT);
		}

        //Farben auswahlfenster
        if(getOption( "auswahl.color_text").equals("")) {
			setOption( "auswahl.color_text",OPTION_AUSWAHL_COLOR_TEXT);
		}
        if(getOption( "auswahl.color_background").equals("")) {
			setOption( "auswahl.color_background",OPTION_AUSWAHL_COLOR_BACKGROUND);
		}
        if(getOption( "auswahl.color_headline_text").equals("")) {
			setOption( "auswahl.color_headline_text",OPTION_AUSWAHL_COLOR_HEADLINE_TEXT);
		}
        if(getOption( "auswahl.color_headline_background").equals("")) {
			setOption( "auswahl.color_headline_background",OPTION_AUSWAHL_COLOR_HEADLINE_BACKGROUND);
		}
        if(getOption( "auswahl.color_markup").equals("")) {
			setOption( "auswahl.color_markup",OPTION_AUSWAHL_COLOR_MARKUP);
		}
        if(getOption( "auswahl.color_markup_green").equals("")) {
			setOption( "auswahl.color_markup_green",OPTION_AUSWAHL_COLOR_MARKUP_GREEN);
		}
        if(getOption( "auswahl.color_erstellt_text").equals("")) {
			setOption( "auswahl.color_erstellt_text",OPTION_AUSWAHL_COLOR_ERSTELLT_TEXT);
		}
        if(getOption( "auswahl.color_erstellt_back").equals("")) {
			setOption( "auswahl.color_erstellt_back",OPTION_AUSWAHL_COLOR_ERSTELLT_BACK);
		}
        if(getOption( "auswahl.color_geandert_text").equals("")) {
			setOption( "auswahl.color_geaendert_text",OPTION_AUSWAHL_COLOR_GEAENDERT_TEXT);
		}
        if(getOption( "auswahl.color_geaendert_back").equals("")) {
			setOption( "auswahl.color_geaendert_back",OPTION_AUSWAHL_COLOR_GEAENDERT_BACK);
		}
        if(getOption( "auswahl.color_adressen_text").equals("")) {
			setOption( "auswahl.color_adressen_text",OPTION_AUSWAHL_COLOR_ADRESSEN_TEXT);
		}
        if(getOption( "auswahl.color_adressen_back").equals("")) {
			setOption( "auswahl.color_adressen_back",OPTION_AUSWAHL_COLOR_ADRESSEN_BACK);
		}
        if(getOption( "auswahl.color_stichworte_text").equals("")) {
			setOption( "auswahl.color_stichworte_text",OPTION_AUSWAHL_COLOR_STICHWORTE_TEXT);
		}
        if(getOption( "auswahl.color_stichworte_back").equals("")) {
			setOption( "auswahl.color_stichworte_back",OPTION_AUSWAHL_COLOR_STICHWORTE_BACK);
		}
        if(getOption( "auswahl.color_hinweis_text").equals("")) {
			setOption( "auswahl.color_hinweis_text",OPTION_AUSWAHL_COLOR_HINWEIS_TEXT);
		}
        if(getOption( "auswahl.color_hinweis_back").equals("")) {
			setOption( "auswahl.color_hinweis_back",OPTION_AUSWAHL_COLOR_HINWEIS_BACK);
		}
        if(getOption( "auswahl.color_yellow_text").equals("")) {
			setOption( "auswahl.color_yellow_text",OPTION_AUSWAHL_COLOR_YELLOW_TEXT);
		}
        if(getOption( "auswahl.color_yellow_back").equals("")) {
			setOption( "auswahl.color_yellow_back",OPTION_AUSWAHL_COLOR_YELLOW_BACK);
		}
        
        if(getOption( "auswahl.color_bestand_yellow_value").equals("")) {
			setOption( "auswahl.color_bestand_yellow_value",COLOR_BESTAND_YELLOW_VALUE);
		}
        
        if(getOption( "auswahl.color_bestand_red_value").equals("")) {
			setOption( "auswahl.color_bestand_red_value",COLOR_BESTAND_RED_VALUE);
		}
        if(options.getProperty("color.mhd.warnung")== null) {
        	setOption("color.mhd.warnung",COLOR_MHD_WARNUNG);
        }
        if(getOption( "auswahl.color_bestand_yellow").equals("")) {
			setOption( "auswahl.color_bestand_yellow",COLOR_BESTAND_YELLOW);
		}
        if(getOption( "auswahl.color_bestand_green").equals("")) {
			setOption( "auswahl.color_bestand_green",COLOR_BESTAND_GREEN);
		}
        if(getOption( "auswahl.color_bestand_red").equals("")) {
			setOption( "auswahl.color_bestand_red",COLOR_BESTAND_RED);
		}
        if(getOption( "auswahl.color_bestand_gray").equals("")) {
			setOption( "auswahl.color_bestand_gray",COLOR_BESTAND_GRAY);
		}
        
        if(getOption( "auswahl.bestand_fillwidth").equals("")) {
			setOption( "auswahl.bestand_fillwidth",AUSWAHL_BESTAND_FILLWIDTH);
		}
        if(getOption( "auswahl.bestand_einheit").equals("")) {
			setOption( "auswahl.bestand_einheit",AUSWAHL_BESTAND_EINHEIT);
		}
        if(getOption( "auswahl.bestand_fillchar").equals("")) {
			setOption( "auswahl.bestand_fillchar",AUSWAHL_BESTAND_FILLCHAR);
		}

        if(getOption( "mischungen.ok_button_color").equals("")) {
			setOption( "mischungen.ok_button_color",OPTION_COLOR_MISCHUNG_BUTTON_OK);
		}
        
        
        if(!options.containsKey("tanklagerpanel.color_fastleer")) {
        	setOption("tanklagerpanel.color_fastleer",COLOR_TANKLAGERPANEL_FASTLEER);
        }
        
        // Logging
        if(getOption( "log.level").equals("")) {
			setOption( "log.level",LogFactory.DEFAULT_LEVEL);
		}
        if(getOption( "log.count").equals("")) {
			setOption( "log.count",LogFactory.DEFAULT_COUNT);
		}


        // Bestätigungsmeldungen

        if(getOption( "confirm.abgang").equals("")) {
			setOption( "confirm.abgang",CONFIRM_ABGANG);
		}
        if(getOption( "confirm.zugang").equals("")) {
			setOption( "confirm.zugang",CONFIRM_ZUGANG);
		}
        if(getOption( "confirm.buchung").equals("")) {
			setOption( "confirm.buchung",CONFIRM_BUCHUNG);
		}

        //invalid chars
    //    if(getOption( "invalid_chars").equals("")) {
			setOption( "invalid_chars",INVALID_CHARS);
	//	}

        //Formulare im auswahlfenster
        if(getOption( "auswahl.formular_rezeptur").equals("")) {
			setOption( "auswahl.formular_rezeptur",AUSWAHL_FORMULAR_REZEPTUR);
		}
        if(getOption( "auswahl.formular_kalkulation").equals("")) {
			setOption( "auswahl.formular_kalkulation",AUSWAHL_FORMULAR_KALKULATION);
		}
        if(getOption( "auswahl.formular_spezifikation").equals("")) {
			setOption( "auswahl.formular_spezifikation",AUSWAHL_FORMULAR_SPEZIFIKATION);
		}
        if(getOption( "auswahl.formular_deckblatt_spezifikation").equals("")) {
			setOption( "auswahl.formular_deckblatt_spezifikation",AUSWAHL_FORMULAR_SPEZIFIKATION);
		}
        if(getOption( "auswahl.tab1_state").equals("")) {
			setOption( "auswahl.tab1_state",0);
		}
        //Zutatendialog

        if(getOption( "zutatendialog.width").equals("")) {
			setOption( "zutatendialog.width",ZutatenDialog.ZUTATENDIALOG_CHAR_WIDTH);
		}
        if(getOption( "zutatendialog.height").equals("")) {
			setOption( "zutatendialog.height",ZutatenDialog.ZUTATENDIALOG_CHAR_HEIGHT);
		}

        //Lagerfenster
        if(getOption( "lager.auswahl").equals("")) {
			setOption( "lager.auswahl",Lager.DEFAULT_AUSWAHL);
		}

        //Sponsoring
        if(getOption( "sponsor.splash").equals("")) {
			setOption( "sponsor.splash",SPONSOR_SPLASH);
		}
        if(getOption( "sponsor.info").equals("")) {
			setOption( "sponsor.info",SPONSOR_INFO);
		}
        if(getOption( "sponsor.button").equals("")) {
			setOption( "sponsor.button",SPONSOR_BUTTON);
		}
        if(getOption( "sponsor.link").equals("")) {
			setOption( "sponsor.link",SPONSOR_LINK);
		}
        if(getOption( "sponsor.browser").equals("")) {
			setOption( "sponsor.browser",SPONSOR_BROWSER);
		}


        //Brennwert
        if(getOption( "brennwert.alkohol_kj").equals("")) {
			setOption( "brennwert.alkohol_kj",BRENNWERT_ALKOHOL_KJ);
		}
        if(getOption( "brennwert.kj_to_kk").equals("")) {
			setOption( "brennwert.kj_to_kk",BRENNWERT_KJ_TO_KCAL);
		}
        if(getOption( "brennwert.kj_to_be").equals("")) {
			setOption( "brennwert.kj_to_be",BRENNWERT_KJ_TO_BE);
		}

        //Statistik-Grafik
        if(getOption( "st_grafik.herstellung_selected").equals("")) {
			setOption( "st_grafik.herstellung_selected",ST_GRAFIK_HERSTELLUNG_SELECTED);
		}
        if(getOption( "st_grafik.statistik_selected").equals("")) {
			setOption( "st_grafik.statistik_selected",ST_GRAFIK_STATISTIK_SELECTED);
		}
        if(getOption( "st_grafik.herstellung_typ").equals("")) {
			setOption( "st_grafik.herstellung_typ",StatistikItem.STATISTIK_3D);
		}
        if(getOption( "auswahl.fuellgewichte").equals("")) {
			setOption( "auswahl.fuellgewichte",FUELLGEWICHT_LISTE);
		}
        if(getOption( "dbbuchung.tank_regex").equals("")) {
			setOption( "dbbuchung.tank_regex",DBBUCHUNG_TANK_REGEX);
		}
        if(getOption( "dbbuchung.tank_se").equals("")) {
			setOption( "dbbuchung.tank_se",DBBUCHUNG_TANK_SE);
		}
        if(getOption( "dbbuchung.tank_sb").equals("")) {
			setOption( "dbbuchung.tank_sb",DBBUCHUNG_TANK_SB);
		}
        if(getOption( "dbbuchung.tickets_regex").equals("")) {
			setOption( "dbbuchung.tickets_regex",DBBUCHUNG_TICKETS_REGEX);
		}
        if(getOption( "dbbuchung.tickets_se").equals("")) {
			setOption( "dbbuchung.tickets_se",DBBUCHUNG_TICKETS_SE);
		}
        if(getOption( "dbbuchung.tickets_sb").equals("")) {
			setOption( "dbbuchung.tickets_sb",DBBUCHUNG_TICKETS_SB);
		}
        
        
        if(getOption( "lieferschein.abfuelltag").equals("")) {
			setOption( "lieferschein.abfuelltag",LIEFERSCHEIN_ABFUELLTAG);
		}
        
        if(getOption( "lieferscheinliste.abfuelltag").equals("")) {
			setOption( "lieferscheinliste.abfuelltag",LIEFERSCHEINLISTE_ABFUELLTAG);
		}
        
        if(getOption( "lieferscheinliste.abfuelltag").equals("")) {
			setOption( "lieferscheinliste.l_muster",LIEFERSCHEINLISTE_L_MUSTER);
		}
        
        if(getOption( "rezeptur.temperatur_default").equals("")) {
			setOption( "rezeptur.temperatur_default",REZEPTUR_TEMPERATUR_DEFAULT);
		}
        if(getOption( "rezeptur.temperatur_min").equals("")) {
			setOption( "rezeptur.temperatur_min",REZEPTUR_TEMPERATUR_MIN);
		}
        if(getOption( "rezeptur.temperatur_max").equals("")) {
			setOption( "rezeptur.temperatur_max",REZEPTUR_TEMPERATUR_MAX);
		}
        //Kalender
        if(getOption( "kalender.typ").equals("")) {
			setOption( "kalender.typ",DBKalender.KALENDER_MONAT);
		}
        if(getOption( "kalender.anzeige").equals("")) {
			setOption( "kalender.anzeige",DBKalender.KALENDER_ANZEIGE_TERMIN_DEFAULT);
		}
        
        if(getOption( "kalender.fontsize").equals("")) {
			setOption( "kalender.fontsize",KalenderItem.DEFAULT_FONTSIZE);
		}
        //Trece
        if(!options.containsKey("trace.level.step")) {
        		setOption("trace.level.step",TraceLineItem.LEVEL_STEP);
        }
        // Icons holen

        abfrageListIcon = new javax.swing.ImageIcon(getClass().getResource(getOption("abfrageliste.icon_classpath")));
        abfrageListPrivatIcon = new javax.swing.ImageIcon(getClass().getResource(getOption("abfrageliste.icon_privat_classpath")));
        ergebnisListNotizIcon = new javax.swing.ImageIcon(getClass().getResource(getOption("ergebnisliste.icon_notiz_classpath")));
        ergebnisListRezepturIcon = new javax.swing.ImageIcon(getClass().getResource(getOption("ergebnisliste.icon_rezeptur_classpath")));
        ergebnisListAusstattungIcon = new javax.swing.ImageIcon(getClass().getResource(getOption("ergebnisliste.icon_ausstattung_classpath")));
        ergebnisListVerweisIcon = new javax.swing.ImageIcon(getClass().getResource(getOption("ergebnisliste.icon_verweis_classpath")));
        containerSelected = new javax.swing.ImageIcon(getClass().getResource(getOption("container.ordner_selected_classpath")));
        containerUnselected = new javax.swing.ImageIcon(getClass().getResource(getOption("container.ordner_unselected_classpath")));
        containerFass = new javax.swing.ImageIcon(getClass().getResource(getOption("container.fass_classpath")));

        //farben statistik
        if(getOption( "stgrafik.farbe_0").equals("")) {
			setOption( "stgrafik.farbe_0","ff0000");
		}
        if(getOption( "stgrafik.farbe_1").equals("")) {
			setOption( "stgrafik.farbe_1","00ff00");
		}
        if(getOption( "stgrafik.farbe_2").equals("")) {
			setOption( "stgrafik.farbe_2","0000ff");
		}
        if(getOption( "stgrafik.farbe_3").equals("")) {
			setOption( "stgrafik.farbe_3","ffff00");
		}
        if(getOption( "stgrafik.farbe_4").equals("")) {
			setOption( "stgrafik.farbe_4","00ffff");
		}
        if(getOption( "stgrafik.farbe_5").equals("")) {
			setOption( "stgrafik.farbe_5","000000");
		}
        if(getOption( "stgrafik.farbe_6").equals("")) {
			setOption( "stgrafik.farbe_6","000000");
		}
        if(getOption( "stgrafik.farbe_7").equals("")) {
			setOption( "stgrafik.farbe_7","000000");
		}
        if(getOption( "stgrafik.farbe_8").equals("")) {
			setOption( "stgrafik.farbe_8","000000");
		}
        if(getOption( "stgrafik.farbe_9").equals("")) {
			setOption( "stgrafik.farbe_9","000000");
		}
        if(getOption( "stgrafik.farbe_10").equals("")) {
			setOption( "stgrafik.farbe_10","000000");
		}
        if(getOption( "stgrafik.farbe_11").equals("")) {
			setOption( "stgrafik.farbe_11","000000");
		}
        if(getOption( "stgrafik.farbe_12").equals("")) {
			setOption( "stgrafik.farbe_12","000000");
		}
        
        if(getOption( "mischungslistenfenster.abfrage_anzahl",0) == 0) {
			setOption("mischungslistenfenster.abfrage_anzahl",MISCHUNGSLISTENFENSTER_ABFRAGE_ANZAHL);
		}
        
        //Stammbaumfenster-defaults
        if(getOption( "stammbaumpanel.zoom",0) == 0) {
			setOption("stammbaumpanel.zoom",stammbaumPanel.DEFAULT_ZOOM);
		}
        if(getOption( "stammbaumpanel.fontsize",0) == 0) {
			setOption("stammbaumpanel.fontsize",stammbaumPanel.DEFAULT_FONTSIZE);
		}
        if(getOption( "stammbaumpanel.cwidth",0) == 0) {
			setOption("stammbaumpanel.cwidth",stammbaumPanel.DEFAULT_WIDTH);
		}
        if(getOption( "stammbaumpanel.margin",0) == 0) {
			setOption("stammbaumpanel.margin",stammbaumPanel.DEFAULT_MARGIN_H);
		}
        if(getOption( "stammbaumpanel.spacingv",0) == 0) {
			setOption("stammbaumpanel.spacingv",stammbaumPanel.DEFAULT_SPACING_V);
		}
        if(getOption( "stammbaumpanel.spacing",0) == 0) {
			setOption("stammbaumpanel.spacing",stammbaumPanel.DEFAULT_SPACING);
		}
        //DAtenblatt
        if(getOption("datenblatt.default").equals("")) {
        	setOption( "datenblatt.default",DATENBLATT_DEFAULT);
        }
        
        if(this.options.getProperty("database.driver") == null) {
			setOption("database.driver",DBFactory.DefaultDataBaseDriver);
		}
        //Auswahl
        if(this.options.getProperty("ausgabe.auswahl_dichte_anzeigen") == null) {
        	setOption("ausgabe.auswahl_dichte_anzeigen",AUSWAHL_DICHTE_ANZEIGEN);
        }
        
        //inventureingabe
        if(this.options.getProperty("inventureingabe.prefix") == null) {
        	setOption("inventureingabe.prefix",INVENTUREINGABE_PREFIX);
        }
        
        if(options.getProperty("ticketliste.delete_html_max_value") == null) {
        	setOption("ticketliste.delete_html_max_value",de.lunqual.rzpro.items.mischungen.TicketListe.MAX_VALUE_LISTE);
        }
        if(options.getProperty("erledigenDialog.tank_columns") == null) {
        	setOption("erledigenDialog.tank_columns",de.lunqual.rzpro.fenster.dialoge.ErledigenDialog.TANK_COLUMNS);
        }
        
        if(options.getProperty("erledigenDialog.dm_tage") == null) {
        	setOption("erledigenDialog.dm_tage",de.lunqual.rzpro.fenster.dialoge.ErledigenDialog.DEFAULT_DM_TAGE);
        }
        
        //barcode
        if(options.getProperty("barcode_width") == null) {
        	setOption("barcode_width",BARCODE_WIDTH);
        }
        if(options.getProperty("barcode_offset") == null) {
        	setOption("barcode_offset",BARCODE_OFFSET);
        }

        //verbrauch
        if(options.getProperty("verbrauch.jahre") == null) {
        	setOption("verbrauch.jahre",DBBuchung.DEFAULT_VERBRAUCH_JAHRE);
        }
        
        //trace
        if(options.getProperty("tracefenster.limit") == null) {
        	setDouble("tracefenster.limit",DEFAULT_TRACE_LIMIT);
        }
        if(options.getProperty("inventureingabe.staerke_aus_rezeptur") == null) {
        	setOption("inventureingabe.staerke_aus_rezeptur", 1);
        }
        
        if(!options.containsKey("tanklager.layout")) {
        	setOption("tanklager.layout", DEFAULT_TANKLAGER_LAYOUT);
        }
        
        if(!options.containsKey("tanklager.zoom")) {
        	setOption("tanklager.zoom", DEFAULT_TANKLAGER_ZOOM);
        }
        
        if(!options.contains("tankliste.belegung.last.count")) {
        	setOption("tankliste.belegung.last.count",TANKLISTE_BELEGUNG_LAST_COUNT);
        }
        
        if(!options.containsKey("lieferschein.save_ean_prefix")) {
        	setOption("lieferschein.save_ean_prefix",LIEFERSCHEIN_EAN_DEFAULT_PREFIX);
        }
        if(!options.containsKey("etiketten.save_ean_prefix")) {
        	setOption("etiketten.save_ean_prefix",ETIKETTEN_EAN_DEFAULT_PREFIX);
        }
        if(!options.containsKey("tanklagerpanel.bemerkungen_fontsize")) {
        	setOption("tanklagerpanel.bemerkungen_fontsize",TANKLAGERPANEL_BEMERKUNGEN_FONTSIZE);
        }

        if(!options.containsKey("main.resolution.min.layout.switch")) {
        	setOption("main.resolution.min.layout.switch",MAIN_RESOLUTION_MIN_LAYOUT_SWITCH);
        }
        
        if(!options.containsKey("mischung.chart.max.colors")) {
        	setOption("mischung.chart.max.colors", MISCHUNG_CHART_MAX_COLORS);
        }
        
        if(!options.containsKey("mischung.chart.max.list")) {
        	setOption("mischung.chart.max.list", MISCHUNG_CHART_MAX_LIST);
        }
        if(!options.containsKey("mischung.chart.list")) {
        	setOption("mischung.chart.list", MISCHUNG_CHART_LIST);
        }

        if(!options.containsKey("mischung.chart.color_0")) {        	setOption("mischung.chart.color_0",CHART_COLOR_0);        }
        if(!options.containsKey("mischung.chart.color_1")) {        	setOption("mischung.chart.color_1",CHART_COLOR_1);        }
        if(!options.containsKey("mischung.chart.color_2")) {        	setOption("mischung.chart.color_2",CHART_COLOR_2);        }
        if(!options.containsKey("mischung.chart.color_3")) {        	setOption("mischung.chart.color_3",CHART_COLOR_3);        }
        if(!options.containsKey("mischung.chart.color_4")) {        	setOption("mischung.chart.color_4",CHART_COLOR_4);        }
        if(!options.containsKey("mischung.chart.color_5")) {        	setOption("mischung.chart.color_5",CHART_COLOR_5);        }
        if(!options.containsKey("mischung.chart.color_6")) {        	setOption("mischung.chart.color_6",CHART_COLOR_6);        }
        if(!options.containsKey("mischung.chart.color_7")) {        	setOption("mischung.chart.color_7",CHART_COLOR_7);        }
        if(!options.containsKey("mischung.chart.color_8")) {        	setOption("mischung.chart.color_8",CHART_COLOR_8);        }
        if(!options.containsKey("mischung.chart.color_9")) {        	setOption("mischung.chart.color_9",CHART_COLOR_9);        }
        if(!options.containsKey("mischung.chart.color_10")) {        	setOption("mischung.chart.color_10",CHART_COLOR_10);        }
        if(!options.containsKey("mischung.chart.color_11")) {        	setOption("mischung.chart.color_11",CHART_COLOR_11);        }
        if(!options.containsKey("mischung.chart.color_12")) {        	setOption("mischung.chart.color_12",CHART_COLOR_12);        }
        if(!options.containsKey("mischung.chart.color_13")) {        	setOption("mischung.chart.color_13",CHART_COLOR_13);        }
        if(!options.containsKey("mischung.chart.color_14")) {        	setOption("mischung.chart.color_14",CHART_COLOR_14);        }
        if(!options.containsKey("mischung.chart.color_15")) {        	setOption("mischung.chart.color_15",CHART_COLOR_15);        }
        if(!options.containsKey("rzsimpledatepicker.format"))  {  		setOption("rzsimpledatepicker.format", DATEPICKER_FORMAT); }
        
        if(!options.containsKey("dokumentpanel.min_scale"))  {  		setOption("dokumentpanel.min_scale",DOKUMENTPANEL_MIN_SCALE); }
        if(!options.containsKey("dokumentpanel.max_scale"))  {  		setOption("dokumentpanel.max_scale",DOKUMENTPANEL_MAX_SCALE); }
        
        
        if(!options.containsKey("tanklager.zoom"))  {  		setOption("tanklager.zoom",100); }
        if(!options.containsKey("tanklager-auswahl.zoom"))  {  		setOption("tanklager-auswahl.zoom",100); }
        
        if(!options.containsKey("tanklager.preferred.width"))  {  		setOption("tanklager.preferred.width",TANKLAGER_PREFERRED_WIDTH); }
        if(!options.containsKey("tanklager.preferred.height"))  {  		setOption("tanklager.preferred.height",TANKLAGER_PREFERRED_HEIGHT); }
        if(!options.containsKey("tanklager.mode.fix"))  {  		setOption("tanklager.mode.fix",TANKLAGER_MODE_FIX); }
        if(!options.containsKey("tanklager.min.size"))  {  		setOption("tanklager.min.size",TANKLAGER_MIN_SIZE); }
        if(!options.containsKey("tanklager.max.size"))  {  		setOption("tanklager.max.size",TANKLAGER_MAX_SIZE); }
        
        
        if(!options.containsKey("changes.markup.color_background")) {  	setOption("changes.markup.color_background",CHANGES_MARKUP_BACKGROUND);        }
        if(!options.containsKey("changes.markup.color_text")) {        	setOption("changes.markup.color_text",CHANGES_MARKUP_TEXT);        }
        if(!options.containsKey("changes.markup.alt.color_background")) {  	setOption("changes.markup.alt.color_background",CHANGES_MARKUP_OLD_BACKGROUND);        }
        if(!options.containsKey("changes.markup.alt.color_text")) {        	setOption("changes.markup.alt.color_text",CHANGES_MARKUP_OLD_TEXT);   }
        
        if(!options.containsKey("verlauf.range.max")) {        	setOption("verlauf.range.max",VERLAUF_RANGE_MAX);   }
        
        if(!options.containsKey("last.orders.count")) {        	setOption("last.orders.count",LAST_ORDERS_COUNT);   }
        if(!options.containsKey("laborwerte.decimal_digits")) {        	setOption("laborwerte.decimal_digits",LABORWERTE_DECIMAL_DIGITS);   }

        if(!options.containsKey("csv.character")) {        	setOption("csv.character", CSV_CHARACTER);   }

        
    //    if(!options.containsKey("pdfdocument.scale")) {setOption("pdfdocument.scale",100);}
        
//        // Farben erzeugen
        bestandGruen=new Color(220,255,220);
        bestandGelb=new Color(255,255,220);
        bestandRot=new Color(255,220,220);
        bestandWasser=new Color(180,230,255);
        bestandWhite = Color.WHITE;
        selectionForeground = Color.WHITE;
        selectionBackground = Color.BLUE;
        textHighlightForeground = Color.BLACK;
        textHighlightBackground= new Color(255,255,220);
        textHeadlineBackground = new Color(255,255,220);
        listForegroundNormal = Color.BLACK;
        listForegroundSelected = new Color(0,0,255);
        listBackgroundNormal = Color.WHITE;
        listBackgroundSelected = new Color(220,220,255);
        listEmpty = Color.WHITE;
        verweisVerweis = new Color(255,187,0);
        verweisText = new Color(255,255,142);
        rechnenStern = new Color(144,194,255);
        listOdd = new Color(255,255,220);
        listEven = Color.WHITE;
        red = Color.RED;
        green=Color.GREEN;
        white= Color.WHITE;
        inventurLiter=new Color(200,240,255);
        inventurGewicht = new Color(255,255,220);
        inventurLeer=Color.WHITE;
        statistikRezepturAlternate = new Color(255,255,220);
        listBackgroundGelb = new Color (255,255,180);
        visibleGridColor=new Color(200,200,200);
        
        
        
        if(noFile) {	
            saveOptions();
        }
    }


    /**
     * schreibt die Properties in die Property-Datei
     */
    public void saveOptions(){
        try{
            rz.getLocale().createNumberFormats();

        } catch(final Exception e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "OptionControl.saveOptions.createnumberFormats" ,  e.getLocalizedMessage());
        }
        
        String[] filenames = {
        		getPropertyFolder() + System.getProperty("file.separator") + OPTION_FILE,
        };
		try {
			if(options != null) {
				if(rz.getDatabase()!=null && rz.getDatabase().getOptionen() != null) { 
					rz.getDatabase().getOptionen().saveOptionen(DBOptionen.OPTION_TYP_OPTION, options,url1);
				}
			}
			for(String filename: filenames) {
	            final FileOutputStream out = new FileOutputStream(filename);
	            options.store(out, "RzPro allgemeine Optionen");
	            out.close();
			}
		}
		catch (final IOException e ){
	             rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "OptionControl.saveOptions:" ,  e.getLocalizedMessage());
	   }
    }

    /**
     * alle Farbwerte zurücksetzen
     *
     */
    public void resetColors() {
        // Farben Herstellbuch
        setOption( "herstellbuch.color_zugang",OPTION_HERSTELLBUCH_COLOR_ZUGANG);
        setOption( "herstellbuch.color_abgang",OPTION_HERSTELLBUCH_COLOR_ABGANG);
        setOption( "herstellbuch.color_losnummer",OPTION_HERSTELLBUCH_COLOR_LOSNUMMER);
        setOption( "herstellbuch.color_herstellung_back",OPTION_HERSTELLBUCH_COLOR_HERSTELLUNG);
        setOption( "herstellbuch.color_endmenge_back",OPTION_HERSTELLBUCH_COLOR_ENDMENGE);
        setOption( "herstellbuch.color_schwund_back",OPTION_HERSTELLBUCH_COLOR_SCHWUND);
        setOption( "herstellbuch.color_herstellung_text",OPTION_HERSTELLBUCH_COLOR_HERSTELLUNG_TEXT);
        setOption( "herstellbuch.color_endmenge_text",OPTION_HERSTELLBUCH_COLOR_ENDMENGE_TEXT);
        setOption( "herstellbuch.color_schwund_text",OPTION_HERSTELLBUCH_COLOR_SCHWUND_TEXT);

        // Farben auswahlfenster
        setOption( "auswahl.color_text",OPTION_AUSWAHL_COLOR_TEXT);
        setOption( "auswahl.color_background",OPTION_AUSWAHL_COLOR_BACKGROUND);
        setOption( "auswahl.color_headline_text",OPTION_AUSWAHL_COLOR_HEADLINE_TEXT);
        setOption( "auswahl.color_headline_background",OPTION_AUSWAHL_COLOR_HEADLINE_BACKGROUND);
        setOption( "auswahl.color_markup",OPTION_AUSWAHL_COLOR_MARKUP);
        setOption( "auswahl.color_erstellt_text",OPTION_AUSWAHL_COLOR_ERSTELLT_TEXT);
        setOption( "auswahl.color_erstellt_back",OPTION_AUSWAHL_COLOR_ERSTELLT_BACK);
        setOption( "auswahl.color_geaendert_text",OPTION_AUSWAHL_COLOR_GEAENDERT_TEXT);
        setOption( "auswahl.color_geaendert_back",OPTION_AUSWAHL_COLOR_GEAENDERT_BACK);
        setOption( "auswahl.color_adressen_text",OPTION_AUSWAHL_COLOR_ADRESSEN_TEXT);
        setOption( "auswahl.color_adressen_back",OPTION_AUSWAHL_COLOR_ADRESSEN_BACK);
        setOption( "auswahl.color_stichworte_text",OPTION_AUSWAHL_COLOR_STICHWORTE_TEXT);
        setOption( "auswahl.color_stichworte_back",OPTION_AUSWAHL_COLOR_STICHWORTE_BACK);
        setOption( "auswahl.color_hinweis_text",OPTION_AUSWAHL_COLOR_HINWEIS_TEXT);
        setOption( "auswahl.color_hinweis_back",OPTION_AUSWAHL_COLOR_HINWEIS_BACK);
        setOption( "auswahl.color_yellow_text",OPTION_AUSWAHL_COLOR_YELLOW_TEXT);
        setOption( "auswahl.color_yellow_back",OPTION_AUSWAHL_COLOR_YELLOW_BACK);
        setOption( "auswahl.color_markup",OPTION_AUSWAHL_COLOR_MARKUP_GREEN);
    }
    /** gibt Farben als Hex-Strings zurück
     * @param key Option-Key
    */
	public String getHexColor(String key) {
		String ret=getOption(key);
		if(ret.equals("")) {
			ret = "000000";
		}
   		return ret;
    }
	/**
	 * gibt eine Farbe #ffffff aus einem Optionskey zurück
	 * @param key
	 * @return
	 */
	public Color getRGBColor(String key) {
		int r =0;
		int g = 0;
		int b=0;
		String c = getOption(key);
		if(c.equals("")) {
			c = "000000";
		}
		try {
			r = Integer.decode("#" + c.substring(0,2)).intValue();
			g = Integer.decode("#" + c.substring(2,4)).intValue();
			b= Integer.decode("#" + c.substring(4,6)).intValue();
		}
		catch(final Exception e) {
			r=0;g=0;b=0;
		}
		return new Color(r,g,b);
	}
	/**
	 * gibt eine Farbe aus einem String zurück
	 * @param key
	 * @return
	 */
	public Color getRGBColorString(String c) {
		int r =0;
		int g = 0;
		int b=0;
		if(c.equals("")) {
			c = "000000";
		}
		try {
			r = Integer.decode("#" + c.substring(0,2)).intValue();
			g = Integer.decode("#" + c.substring(2,4)).intValue();
			b= Integer.decode("#" + c.substring(4,6)).intValue();
		}
		catch(final Exception e) {
			r=0;g=0;b=0;
		}
		return new Color(r,g,b);
	}

	/**
	 * setzt Farben als OPtionen
	 * @param key  Options-Key
	 * @param c  Farbe
	 */
	public void setHexColor(String key, Color c) {
		String r,g,b;
		r=Integer.toHexString(c.getRed());if(r.length()==1) {
			r = "0"+r;
		}
		g=Integer.toHexString(c.getGreen());if(g.length()==1) {
			g = "0"+g;
		}
		b=Integer.toHexString(c.getBlue());if(b.length()==1) {
			b = "0"+b;
		}

		setOption(key,r+g+b);
	}

	/**
	 * gibt Farbe als Hex-String zurück
	 * @param c  Farbe
	 * @return hex-string
	 */
	public String getHexColor( Color c) {
		String r,g,b;
		r=Integer.toHexString(c.getRed());if(r.length()==1) {
			r = "0"+r;
		}
		g=Integer.toHexString(c.getGreen());if(g.length()==1) {
			g = "0"+g;
		}
		b=Integer.toHexString(c.getBlue());if(b.length()==1) {
			b = "0"+b;
		}
		return r+g+b;
	}

	/**
	 * gibt einen modifizierten String zurück, der keine invalid characters enthält
	 * Invalid characters sind alle, die als regular expression mistverstanden werden
	 * können und deshalb in Losnummern nicht auftauchen dürfen !
	 * @param in String   EingabeString
	 * @return derselbe String, nur ohne die invalid characters
	 */
	public String deleteInvalidChars(String in) {
		String ret = "";
		final String invalid = getOption("invalid_chars");
		boolean copy = true;
		for(int i = 0;i < in.length();i++) {
			copy = true; // wenn copy = true, wird der char übernommen, wenn false, nicht
			for (int j=0;j<invalid.length();j++) {
				if(in.charAt(i)==invalid.charAt(j)) {
					copy = false;
					break;
				}
			}
			if(copy) {
				ret += in.charAt(i);
			}
		}
		return ret;
	}
    /**
     * Icon getIcon(String) holt ein bestimmtes Icon
     * @param aKey Klassenpfad zu einem Icon
     * @return gibt ein Icon zurück
     */
     public Icon getIcon(String aKey){
         if (aKey.equals(LIST_ABFRAGE_ICON_CLASSPATH)) {
			return abfrageListIcon;
		}
         if (aKey.equals(LIST_ABFRAGE_ICON_PRIVAT_CLASSPATH)) {
 			return abfrageListPrivatIcon;
 		}
         if (aKey.equals(LIST_ERGEBNIS_ICON_NOTIZ_CLASSPATH)) {
			return ergebnisListNotizIcon;
		}
         if (aKey.equals(LIST_ERGEBNIS_ICON_REZEPTUR_CLASSPATH)) {
			return ergebnisListRezepturIcon;
		}
         if (aKey.equals(LIST_ERGEBNIS_ICON_AUSSTATTUNG_CLASSPATH)) {
			return ergebnisListAusstattungIcon;
		}
         if (aKey.equals(LIST_ERGEBNIS_ICON_VERWEIS_CLASSPATH)) {
			return ergebnisListVerweisIcon;
		}
         if (aKey.equals(LIST_CONTAINER_SELECTED_CLASSPATH)) {
			return containerSelected;
		}
         if (aKey.equals(LIST_CONTAINER_UNSELECTED_CLASSPATH)) {
			return containerUnselected;
		}
         if (aKey.equals(LIST_CONTAINER_FASS_CLASSPATH)) {
			return containerFass;
		}

         return null;
     }

     /**
      * Color getColor(String) holt eine Option und gibt eine
      * Farbe zurück
      * @param aKey Color-Key
      * @return Color-Struktur
      */

    public Color getColor(int aKey) {
     	switch(aKey) {
 		case COLOR_BESTAND_GRUEN 						: return bestandGruen;
		case COLOR_BESTAND_GELB 						: return bestandGelb;
		case COLOR_BESTAND_ROT  						: return bestandRot;
		case COLOR_BESTAND_WHITE						: return bestandWhite;
		case COLOR_BESTAND_WASSER						: return bestandWasser;
	    case COLOR_SELECTION_FOREGROUND 				: return selectionForeground;
	    case COLOR_SELECTION_BACKGROUND 				: return selectionBackground;
	    case COLOR_TEXT_HIGHLIGHT_BACKGROUND			: return textHighlightBackground;
	    case COLOR_TEXT_HIGHLIGHT_FOREGROUND 			: return textHighlightForeground;
	    case COLOR_TEXT_HEADLINE_BACKGROUND				: return textHeadlineBackground;
	    case COLOR_LIST_BACKGROUND_NORMAL 				: return listBackgroundNormal;
	    case COLOR_LIST_BACKGROUND_SELECTED 			: return listBackgroundSelected;
	    case COLOR_LIST_EMPTY							: return listEmpty;
	    case COLOR_LIST_FOREGROUND_NORMAL 				: return listForegroundNormal;
	    case COLOR_LIST_FOREGROUND_SELECTED 			: return listForegroundSelected;
	    case COLOR_VERWEIS_VERWEIS						: return verweisVerweis;
	    case COLOR_VERWEIS_TEXT							: return verweisText;
	    case COLOR_RECHNEN_STERN						: return rechnenStern;
	    case COLOR_LIST_BACKGROUND_ODD					: return listOdd;
	    case COLOR_LIST_BACKGROUND_EVEN					: return listEven;
	    case COLOR_RED									: return red;
	    case COLOR_GREEN								: return green;
	    case COLOR_LIST_INVENTUR_LITER					: return inventurLiter;
	    case COLOR_LIST_INVENTUR_GEWICHT				: return inventurGewicht;
	    case COLOR_LIST_INVENTUR_LEER					: return inventurLeer;
	    case COLOR_STATISTIK_REZEPTUR_ALTERNATE			: return statistikRezepturAlternate;
	    case COLOR_LIST_BACKGROUND_GELB					: return listBackgroundGelb;
	    case COLOR_VISIBLE_GRID							: return visibleGridColor;
	    case COLOR_WHITE								: return white;

     }
 	return null;
    }

    /**
     * setzt eine Option (string)
     * @param option name der option
     * @param value wert
     */
    public void setOption(String option,String value){
        options.setProperty(option,value);
    }
    /**
     * setzt eine Option (int)
     * @param option Schlüssel
     * @param value Wert
     */
    public void setOption(String option,int value){
        options.setProperty(option, String.valueOf(value));
    }
    /**
     * setzt eine Option (double)
     * @param option name der option
     * @param value wert
     */
    public void setOption(String option,double value){
        options.setProperty(option,String.valueOf(value));
    }
    /**
     * holt eine Option
     * @param option name der Option
     * @return wert der Option ein leerer String
     * wenn kein Wert gefunden wurde
     */
    public String getOption(String option){
        return options.getProperty(option,"");
    }
    /**
     * getoption als int
     * @return optionswert oder defaultValue, wenn keine Option gefunden wurde
     * @param option Schlüssel
     * @param defaultValue Dieser Wert wird zurückgegeben, wenn der Schlüssel nicht existiert
     */
    public int  getOption(String option,int defaultValue){
    	try {
    		return Integer.parseInt(options.getProperty(option,String.valueOf(defaultValue)));
    	}catch (Exception e) {
			return defaultValue;
		}
    }
    /** holt ein Integer
     * @param option_key
     * @return integer Wert oder 0, wenn der Schlüssel nicht vorhanden ist
     */
    public int getInt(String option) {
        return Integer.parseInt(options.getProperty(option,"0"));
    }
    /**
     * holt ein Double-Wert
     * @param option Key
     * @return double Wert  oder 0.0 wenn der Schlüssel nicht vorhanden ist
     */
    public double getDouble(String option) {
        try {
            return Double.parseDouble(options.getProperty(option,"0.0"));
        } catch (final NumberFormatException e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "optioncontrol.getdouble", e.getLocalizedMessage());
            return 0.0;
        }
    }
    /**
     * holt ein Double-Wert mit Default-Rückgabe
     * @param option Key
     * @return double Wert  oder defaultValue wenn der Schlüssel nicht vorhanden ist
     */
    public double getDouble(String option,double defaultValue) {
        try {
            return Double.parseDouble(options.getProperty(option,String.valueOf(defaultValue)));
        } catch (final NumberFormatException e) {
            rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "optioncontrol.getdouble", e.getLocalizedMessage());
            return defaultValue;
        }
    }

    /** speichert eine double-zahl locale-formatiert als String
     *
     * @param option   der Schlüssel
     * @param value    der Wert
     */
    public void setDouble(String option,double value) {
        options.setProperty(option,String.valueOf(value));
    }

    /**
     * holt das Homedirectory des Benutzers
     * @return Home-Directory
     */
    public String getUserHomeDirectory(){
        return System.getProperty("user.home");
    }

    public String getPropertyFolder(){
        return getUserHomeDirectory() + System.getProperty("file.separator") + getOption("optioncontrol.folder");
    }

    /**
     * Zahlenformate /StringFormate /Datumsformate
     */
    public MaskFormatter createFormatter(String s) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(s);
        }
        catch (final java.text.ParseException exc) {}
        return formatter;
    }

    public void cleanUp(){
        saveOptions();
    }

    /** erzeugt einen String "###.###.#.0,0##", der dem Numberformat
     * entspricht
     * @param nf   NumberFormat
     * @return String
     */
    public String getNumberFormatString(NumberFormat nf) {
        int i;
        String ret =""; //10 Stellen
        if(rz.getLocale() != null) { //beim ersten Programmstart existiert options VOR locale !
            //nachkommastellen
            String n = "";
            for(i = 0;i < nf.getMaximumFractionDigits();i++) {
                n += i < nf.getMinimumFractionDigits() ? "0" : "#";
            }
            String v = ""; //vorkommastellen sind komplizierter;
            String v1 = "";
            final int max = nf.getMaximumIntegerDigits() > NFF_MAX_STRING ? NFF_MAX_STRING : nf.getMaximumIntegerDigits();
            for(i = 0 ; i< max;i++) {
                v += i < nf.getMinimumFractionDigits() ? "0" : "#";
            }
            for(i = 1;i < v.length()+1;i++) {
                v1+=v.charAt(i-1);
                if((i % 3) == 0) {
					v1+=",";
				}
            }
            v  = ((new StringBuffer(v1)).reverse()).toString();
            // zusammensetzen
            ret = v + "." + n;
        }
        return ret;
    }
    
    public Properties getProperties() {
    	return options;
    }
    
}
